/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sticker.util;

import io.rong.common.rlog.RLog;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;

public class DownloadUtil {
    private static final String TAG = "DownloadUtil";
    private String urlString;
    private List<DownloadListener> listeners = new ArrayList<DownloadListener>();

    public DownloadUtil(String url) {
        this.urlString = url;
    }

    public void download(String savePath) {
        try {
            int count;
            boolean successMkdir;
            URL url = new URL(this.urlString);
            URLConnection connection = url.openConnection();
            connection.connect();
            int totalLength = connection.getContentLength();
            InputStream inputStream = connection.getInputStream();
            BufferedInputStream input = new BufferedInputStream(inputStream, 8192);
            File file = new File(savePath);
            if (!file.getParentFile().exists() && !(successMkdir = file.getParentFile().mkdirs())) {
                RLog.e((String)TAG, (String)"download created folders unSuccessfully");
            }
            FileOutputStream output = new FileOutputStream(savePath);
            int downloadSize = 0;
            byte[] data = new byte[1024];
            while ((count = ((InputStream)input).read(data)) != -1) {
                ((OutputStream)output).write(data, 0, count);
                int progress = (int)((float)(downloadSize += count) / (float)totalLength * 100.0f);
                this.notifyListenersOnProgress(progress);
            }
            output.flush();
            ((OutputStream)output).close();
            ((InputStream)input).close();
            this.notifyListenersOnComplete(savePath);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.notifyListenersOnError(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.notifyListenersOnError(e);
        }
    }

    public void addDownloadListener(DownloadListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private void notifyListenersOnProgress(int progress) {
        for (DownloadListener listener : this.listeners) {
            listener.onProgress(progress);
        }
    }

    private void notifyListenersOnComplete(String path) {
        for (DownloadListener listener : this.listeners) {
            listener.onComplete(path);
        }
    }

    private void notifyListenersOnError(Exception e) {
        for (DownloadListener listener : this.listeners) {
            listener.onError(e);
        }
    }

    public static interface DownloadListener {
        public void onProgress(int var1);

        public void onComplete(String var1);

        public void onError(Exception var1);
    }
}

