/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sticker.mysticker;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import io.rong.eventbus.EventBus;
import io.rong.imageloader.core.DisplayImageOptions;
import io.rong.imageloader.core.ImageLoader;
import io.rong.imkit.widget.adapter.BaseAdapter;
import io.rong.sticker.R;
import io.rong.sticker.businesslogic.StickerPackageDeleteTask;
import io.rong.sticker.model.Event;
import io.rong.sticker.model.StickerPackage;

public class MyStickerListAdapter
extends BaseAdapter<StickerPackage> {
    private OnNoStickerListener listener;

    MyStickerListAdapter(Context context) {
        super(context);
    }

    protected View newView(Context context, int position, ViewGroup group) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.rc_sticker_download_item, group, false);
        new ViewHolder(view, this);
        return view;
    }

    protected void bindView(View v, int position, StickerPackage stickerPackage) {
        ViewHolder holder = (ViewHolder)v.getTag();
        holder.setStickerPackage(stickerPackage);
        holder.setIsLast(position == this.getCount() - 1);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public void setOnNoStickerListener(OnNoStickerListener listener) {
        this.listener = listener;
    }

    private void removePackage(String packageId) {
        int index = -1;
        for (int i = 0; i < this.mList.size(); ++i) {
            if (!((StickerPackage)this.mList.get(i)).getPackageId().equals(packageId)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            this.remove(index);
            this.notifyDataSetChanged();
        }
        if (this.mList.isEmpty() && this.listener != null) {
            this.listener.onNoSticker();
        }
    }

    public static interface OnNoStickerListener {
        public void onNoSticker();
    }

    private static class ViewHolder {
        private MyStickerListAdapter adapter;
        private Context context;
        private ImageView iv;
        private TextView tv;
        private View btn;
        private View divider;
        private String packageId;
        private boolean isPreloadPackage;
        private View.OnClickListener onClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                StickerPackageDeleteTask deleteTask = new StickerPackageDeleteTask(ViewHolder.this.packageId, ViewHolder.this.isPreloadPackage);
                deleteTask.delete();
                ViewHolder.this.adapter.removePackage(ViewHolder.this.packageId);
                EventBus.getDefault().post((Object)new Event.RemovePackageEvent(ViewHolder.this.packageId));
            }
        };

        public ViewHolder(View view, MyStickerListAdapter adapter) {
            this.adapter = adapter;
            this.iv = (ImageView)view.findViewById(R.id.iv);
            this.tv = (TextView)view.findViewById(R.id.tv);
            this.btn = view.findViewById(R.id.btn);
            this.divider = view.findViewById(R.id.divider);
            view.setTag((Object)this);
            this.context = view.getContext();
        }

        public void setStickerPackage(StickerPackage stickerPackage) {
            this.packageId = stickerPackage.getPackageId();
            this.isPreloadPackage = stickerPackage.isPreload() == 1;
            DisplayImageOptions options = new DisplayImageOptions.Builder().cacheInMemory(true).cacheOnDisk(true).build();
            ImageLoader.getInstance().displayImage(stickerPackage.getCover(), this.iv, options);
            this.tv.setText((CharSequence)stickerPackage.getName());
            this.btn.setOnClickListener(this.onClickListener);
        }

        void setIsLast(boolean isLast) {
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)this.divider.getLayoutParams();
            lp.leftMargin = isLast ? 0 : this.context.getResources().getDimensionPixelSize(R.dimen.my_sticker_divider_margin_left);
        }
    }
}

