/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sticker.mysticker;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;
import io.rong.imkit.RongBaseActivity;
import io.rong.sticker.R;
import io.rong.sticker.businesslogic.StickerPackageDbTask;
import io.rong.sticker.model.StickerPackage;
import io.rong.sticker.mysticker.MyStickerListAdapter;
import java.util.List;

public class MyStickerActivity
extends RongBaseActivity {
    private View contentView;
    private View emptyView;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_rc_my_sticker);
        this.title.setText(R.string.my_sticker);
        this.contentView = this.findViewById(R.id.content_view);
        this.emptyView = this.findViewById(R.id.empty_view);
        ListView listView = (ListView)this.findViewById(R.id.rc_list);
        List<StickerPackage> list = StickerPackageDbTask.getInstance().getDownloadPackages();
        if (list.isEmpty()) {
            this.showEmptyView();
        } else {
            this.showContentView();
            MyStickerListAdapter adapter = new MyStickerListAdapter((Context)this);
            adapter.setOnNoStickerListener(new MyStickerListAdapter.OnNoStickerListener(){

                @Override
                public void onNoSticker() {
                    MyStickerActivity.this.showEmptyView();
                }
            });
            adapter.addCollection(list);
            listView.setAdapter((ListAdapter)adapter);
        }
    }

    private void showContentView() {
        this.contentView.setVisibility(0);
        this.emptyView.setVisibility(8);
    }

    private void showEmptyView() {
        this.contentView.setVisibility(8);
        this.emptyView.setVisibility(0);
    }
}

