/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sticker.message;

import android.content.Context;
import android.text.Spannable;
import android.text.SpannableString;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.felipecsl.gifimageview.library.GifImageView;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.utilities.RongUtils;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.sticker.R;
import io.rong.sticker.businesslogic.GifImageLoader;
import io.rong.sticker.message.StickerMessage;
import java.util.Locale;

@ProviderTag(messageContent=StickerMessage.class, showReadState=true)
public class StickerMessageItemProvider
extends IContainerItemProvider.MessageProvider<StickerMessage> {
    private static final String FORMAT = "[%s]";

    public View newView(Context context, ViewGroup group) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.rc_sticker_messsage_item, group, false);
        new ViewHolder(view);
        return view;
    }

    public void bindView(View v, int position, StickerMessage stickerMessage, UIMessage message) {
        ViewGroup.LayoutParams lp = v.getLayoutParams();
        lp.width = RongUtils.dip2px((float)(stickerMessage.getWidth() / 2));
        lp.height = RongUtils.dip2px((float)(stickerMessage.getHeight() / 2));
        v.setLayoutParams(lp);
        final ViewHolder holder = (ViewHolder)v.getTag();
        holder.showLoading();
        final String tag = stickerMessage.getPackageId() + stickerMessage.getStickerId();
        holder.gifImageView.setTag(tag);
        GifImageLoader.getInstance().obtain(stickerMessage, new GifImageLoader.SimpleCallback(){

            @Override
            public void onSuccess(byte[] bytes) {
                if (holder.gifImageView.getTag() != null && holder.gifImageView.getTag().equals(tag)) {
                    holder.showContent();
                    holder.gifImageView.setBytes(bytes);
                    holder.gifImageView.startAnimation();
                }
            }

            @Override
            public void onFail() {
                if (holder.gifImageView.getTag() != null && holder.gifImageView.getTag().equals(tag)) {
                    holder.showFail();
                }
            }
        });
    }

    public Spannable getContentSummary(StickerMessage stickerMessage) {
        String content = String.format(Locale.getDefault(), FORMAT, stickerMessage.getDigest());
        return new SpannableString((CharSequence)content);
    }

    public void onItemClick(View view, int position, StickerMessage content, UIMessage message) {
    }

    private static class ViewHolder {
        private GifImageView gifImageView;
        private View loading;
        private View fail;

        public ViewHolder(View view) {
            this.gifImageView = (GifImageView)view.findViewById(R.id.gif_view);
            this.loading = view.findViewById(R.id.loading);
            this.fail = view.findViewById(R.id.fail);
            view.setTag((Object)this);
        }

        void showLoading() {
            this.loading.setVisibility(0);
            this.gifImageView.setVisibility(8);
            this.fail.setVisibility(8);
        }

        void showFail() {
            this.loading.setVisibility(8);
            this.gifImageView.setVisibility(8);
            this.fail.setVisibility(0);
        }

        void showContent() {
            this.loading.setVisibility(8);
            this.gifImageView.setVisibility(0);
            this.fail.setVisibility(8);
        }
    }
}

