/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sticker.message;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MessageContent;
import io.rong.sticker.model.Sticker;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:StkMsg", flag=3)
public class StickerMessage
extends MessageContent {
    private String packageId;
    private String stickerId;
    private String digest;
    private int width;
    private int height;
    public static final Parcelable.Creator<StickerMessage> CREATOR = new Parcelable.Creator<StickerMessage>(){

        public StickerMessage createFromParcel(Parcel source) {
            return new StickerMessage(source);
        }

        public StickerMessage[] newArray(int size) {
            return new StickerMessage[size];
        }
    };

    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("packageId", (Object)this.packageId);
            jsonObj.put("stickerId", (Object)this.stickerId);
            jsonObj.put("digest", (Object)this.digest);
            jsonObj.put("width", this.width);
            jsonObj.put("height", this.height);
        }
        catch (JSONException e) {
            Log.e((String)"JSONException", (String)e.getMessage());
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.packageId);
        dest.writeString(this.stickerId);
        dest.writeString(this.digest);
        dest.writeInt(this.width);
        dest.writeInt(this.height);
    }

    public StickerMessage() {
    }

    public StickerMessage(byte[] data) {
        try {
            String jsonStr = new String(data, "UTF-8");
            JSONObject jsonObj = new JSONObject(jsonStr);
            this.packageId = jsonObj.optString("packageId");
            this.stickerId = jsonObj.optString("stickerId");
            this.digest = jsonObj.optString("digest");
            this.width = jsonObj.optInt("width");
            this.height = jsonObj.optInt("height");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static StickerMessage obtain(Sticker sticker) {
        StickerMessage stickerMessage = new StickerMessage();
        stickerMessage.setPackageId(sticker.getPackageId());
        stickerMessage.setStickerId(sticker.getStickerId());
        stickerMessage.setDigest(sticker.getDigest());
        stickerMessage.setWidth(sticker.getWidth());
        stickerMessage.setHeight(sticker.getHeight());
        return stickerMessage;
    }

    public String getPackageId() {
        return this.packageId;
    }

    public void setPackageId(String packageId) {
        this.packageId = packageId;
    }

    public String getStickerId() {
        return this.stickerId;
    }

    public void setStickerId(String stickerId) {
        this.stickerId = stickerId;
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public StickerMessage(Parcel in) {
        this.packageId = in.readString();
        this.stickerId = in.readString();
        this.digest = in.readString();
        this.width = in.readInt();
        this.height = in.readInt();
    }
}

