/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sticker.emoticontab;

import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.GridView;
import android.widget.ListAdapter;
import io.rong.imkit.emoticon.IEmoticonTab;
import io.rong.imkit.widget.adapter.BaseAdapter;
import io.rong.sticker.R;
import io.rong.sticker.businesslogic.StickerPackageStorageTask;
import io.rong.sticker.model.Sticker;
import io.rong.sticker.model.StickerPackage;
import io.rong.sticker.widget.IndicatorView;
import io.rong.sticker.widget.StickerGridItemView;
import java.util.List;

public class StickersTab
implements IEmoticonTab {
    private StickerPackage stickerPackage;
    private IndicatorView indicatorView;

    public StickersTab(StickerPackage stickerPackage) {
        this.stickerPackage = stickerPackage;
    }

    public Drawable obtainTabDrawable(Context context) {
        String iconFilePath = StickerPackageStorageTask.getStickerPackageIconFilePath(this.stickerPackage);
        return new BitmapDrawable(context.getResources(), iconFilePath);
    }

    public View obtainTabPager(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.rc_sticker_pages, null);
        ViewPager viewPager = (ViewPager)view.findViewById(R.id.sticker_view_pager);
        StickerPagerAdapter adapter = new StickerPagerAdapter(this.stickerPackage.getStickers());
        viewPager.setAdapter((PagerAdapter)adapter);
        viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                StickersTab.this.indicatorView.setSelect(position);
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.indicatorView = (IndicatorView)view.findViewById(R.id.indicator_view);
        this.indicatorView.setCount(adapter.getCount());
        return view;
    }

    public void onTableSelected(int position) {
    }

    public StickerPackage getStickerPackage() {
        return this.stickerPackage;
    }

    private static class GridViewAdapter
    extends BaseAdapter<Sticker> {
        GridViewAdapter(Context context, List<Sticker> stickers) {
            super(context);
            this.addCollection(stickers);
        }

        protected View newView(Context context, int position, ViewGroup group) {
            return new StickerGridItemView(context);
        }

        protected void bindView(View v, int position, Sticker data) {
            ((StickerGridItemView)v).setSticker(data);
        }

        public long getItemId(int position) {
            return 0L;
        }
    }

    private static class StickerPagerAdapter
    extends PagerAdapter {
        private static final int STICKERS_PER_PAGE = 8;
        private List<Sticker> stickerList;

        StickerPagerAdapter(List<Sticker> stickerList) {
            this.stickerList = stickerList;
        }

        @NonNull
        public Object instantiateItem(@NonNull ViewGroup container, int position) {
            Context context = container.getContext();
            GridView gridView = (GridView)LayoutInflater.from((Context)context).inflate(R.layout.rc_sticker_page, container, false);
            gridView.setAdapter((ListAdapter)new GridViewAdapter(context, this.getStickersForPage(position)));
            container.addView((View)gridView);
            return gridView;
        }

        public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
            container.removeView((View)object);
        }

        public int getCount() {
            return (this.stickerList.size() - 1) / 8 + 1;
        }

        public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
            return view == object;
        }

        private List<Sticker> getStickersForPage(int page) {
            int start = page * 8;
            int end = (page + 1) * 8;
            end = Math.min(end, this.stickerList.size());
            return this.stickerList.subList(start, end);
        }
    }
}

