/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sticker.emoticontab;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import io.rong.imkit.emoticon.IEmoticonTab;
import io.rong.sticker.R;
import io.rong.sticker.model.StickerPackage;
import io.rong.sticker.widget.DownloadStickerView;
import io.rong.sticker.widget.IndicatorView;
import java.util.Iterator;
import java.util.List;

public class RecommendTab
implements IEmoticonTab {
    private List<StickerPackage> packages;
    private IndicatorView indicatorView;
    private ViewPager viewPager;
    private RecommendPackageAdapter adapter;

    public RecommendTab(List<StickerPackage> packages) {
        this.packages = packages;
    }

    public Drawable obtainTabDrawable(Context context) {
        return context.getResources().getDrawable(R.drawable.rc_icon_recommend);
    }

    public View obtainTabPager(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.rc_sticker_download, null);
        this.viewPager = (ViewPager)view.findViewById(R.id.download_view_pager);
        this.adapter = new RecommendPackageAdapter(this.packages);
        this.viewPager.setAdapter((PagerAdapter)this.adapter);
        this.viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                RecommendTab.this.indicatorView.setSelect(position);
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.indicatorView = (IndicatorView)view.findViewById(R.id.indicator_view);
        this.indicatorView.setCount(this.adapter.getCount());
        return view;
    }

    public void onTableSelected(int position) {
    }

    public void setPackages(List<StickerPackage> packages) {
        this.packages = packages;
        this.adapter = new RecommendPackageAdapter(packages);
        this.viewPager.setAdapter((PagerAdapter)this.adapter);
        this.indicatorView.setCount(this.adapter.getCount());
    }

    public void removePackage(StickerPackage stickerPackage) {
        boolean isChanged = false;
        Iterator<StickerPackage> iterator = this.packages.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getPackageId().equals(stickerPackage.getPackageId())) continue;
            iterator.remove();
            isChanged = true;
            break;
        }
        if (this.adapter != null && isChanged) {
            this.adapter.setPackages(this.packages);
            this.adapter.notifyDataSetChanged();
            this.indicatorView.setCount(this.adapter.getCount());
        }
    }

    public boolean isEmpty() {
        return this.adapter.getCount() == 0;
    }

    private static class RecommendPackageAdapter
    extends PagerAdapter {
        private List<StickerPackage> packages;

        RecommendPackageAdapter(List<StickerPackage> packages) {
            this.packages = packages;
        }

        void setPackages(List<StickerPackage> packages) {
            this.packages = packages;
        }

        @NonNull
        public Object instantiateItem(@NonNull ViewGroup container, int position) {
            StickerPackage stickerPackage = this.packages.get(position);
            DownloadStickerView view = new DownloadStickerView(container.getContext());
            view.setStickerPackage(stickerPackage);
            container.addView((View)view);
            return view;
        }

        public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
            container.removeView((View)object);
        }

        public int getCount() {
            return this.packages == null ? 0 : this.packages.size();
        }

        public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
            return view == object;
        }
    }
}

