/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sticker.db;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.provider.BaseColumns;
import io.rong.sticker.model.Sticker;
import java.util.ArrayList;
import java.util.List;

public class StickerTable
implements BaseColumns {
    private static final String NAME = "sticker";
    private static final String COLUMN_STICKER_ID = "stickerId";
    private static final String COLUMN_PACKAGE_ID = "packageId";
    private static final String COLUMN_DIGEST = "digest";
    private static final String COLUMN_THUMB_URL = "thumbUrl";
    private static final String COLUMN_URL = "url";
    private static final String COLUMN_ORDER = "stickerOrder";
    private static final String COLUMN_LOCAL_THUMB_URL = "localThumbUrl";
    private static final String COLUMN_LOCAL_URL = "localUrl";
    private static final String COLUMN_WIDTH = "width";
    private static final String COLUMN_HEIGHT = "height";
    static final String CREATE = "CREATE TABLE sticker (_id INTEGER PRIMARY KEY, stickerId TEXT, packageId TEXT, digest TEXT, thumbUrl TEXT, url TEXT, stickerOrder TEXT, localThumbUrl TEXT, localUrl TEXT, width INTEGER, height INTEGER)";

    public static void insert(SQLiteDatabase db, String packageId, Sticker sticker) {
        ContentValues cv = new ContentValues();
        cv.put(COLUMN_STICKER_ID, sticker.getStickerId());
        cv.put(COLUMN_PACKAGE_ID, packageId);
        cv.put(COLUMN_DIGEST, sticker.getDigest());
        cv.put(COLUMN_THUMB_URL, sticker.getThumbUrl());
        cv.put(COLUMN_URL, sticker.getUrl());
        cv.put(COLUMN_ORDER, Integer.valueOf(sticker.getOrder()));
        cv.put(COLUMN_LOCAL_THUMB_URL, sticker.getLocalThumbUrl());
        cv.put(COLUMN_LOCAL_URL, sticker.getLocalUrl());
        cv.put(COLUMN_WIDTH, Integer.valueOf(sticker.getWidth()));
        cv.put(COLUMN_HEIGHT, Integer.valueOf(sticker.getHeight()));
        db.insert(NAME, null, cv);
    }

    public static void deleteByPackageId(SQLiteDatabase db, String packageId) {
        String selection = "packageId = ?";
        String[] selectionArgs = new String[]{packageId};
        db.delete(NAME, selection, selectionArgs);
    }

    public static List<Sticker> getStickersByPackageId(SQLiteDatabase db, String packageId) {
        String sql = "SELECT * FROM sticker WHERE packageId = ? ORDER BY stickerOrder";
        Cursor cursor = db.rawQuery(sql, new String[]{packageId});
        ArrayList<Sticker> stickers = new ArrayList<Sticker>();
        while (cursor.moveToNext()) {
            Sticker sticker = new Sticker();
            sticker.setStickerId(cursor.getString(cursor.getColumnIndex(COLUMN_STICKER_ID)));
            sticker.setPackageId(cursor.getString(cursor.getColumnIndex(COLUMN_PACKAGE_ID)));
            sticker.setDigest(cursor.getString(cursor.getColumnIndex(COLUMN_DIGEST)));
            sticker.setThumbUrl(cursor.getString(cursor.getColumnIndex(COLUMN_THUMB_URL)));
            sticker.setUrl(cursor.getString(cursor.getColumnIndex(COLUMN_URL)));
            sticker.setLocalThumbUrl(cursor.getString(cursor.getColumnIndex(COLUMN_LOCAL_THUMB_URL)));
            sticker.setLocalUrl(cursor.getString(cursor.getColumnIndex(COLUMN_LOCAL_URL)));
            sticker.setOrder(cursor.getInt(cursor.getColumnIndex(COLUMN_ORDER)));
            sticker.setWidth(cursor.getInt(cursor.getColumnIndex(COLUMN_WIDTH)));
            sticker.setHeight(cursor.getInt(cursor.getColumnIndex(COLUMN_HEIGHT)));
            stickers.add(sticker);
        }
        cursor.close();
        return stickers;
    }
}

