/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sticker.db;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.provider.BaseColumns;
import io.rong.sticker.model.StickerPackage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StickerPackageTable
implements BaseColumns {
    public static final String NAME = "sticker_package";
    private static final String COLUMN_PACKAGE_ID = "packageId";
    private static final String COLUMN_NAME = "name";
    private static final String COLUMN_PRELOAD = "preload";
    private static final String COLUMN_AUTHOR = "author";
    private static final String COLUMN_URL = "url";
    private static final String COLUMN_ICON = "icon";
    private static final String COLUMN_COVER = "cover";
    private static final String COLUMN_COPYRIGHT = "copyright";
    private static final String COLUMN_CREATE_TIME = "createTime";
    private static final String COLUMN_DIGEST = "digest";
    private static final String COLUMN_ORDER = "packageOrder";
    private static final String COLUMN_IS_DOWNLOAD = "is_download";
    static final String CREATE = "CREATE TABLE sticker_package (_id INTEGER PRIMARY KEY, packageId TEXT UNIQUE, name TEXT, preload INTEGER, author TEXT, url TEXT, icon TEXT, cover TEXT, copyright TEXT, createTime INTEGER, digest TEXT, packageOrder INTEGER, is_download BOOLEAN DEFAULT 0)";

    public static List<StickerPackage> getAllPackages(SQLiteDatabase db) {
        String sql = "SELECT * FROM sticker_package ORDER BY preload DESC, packageOrder";
        Cursor cursor = db.rawQuery(sql, null);
        ArrayList<StickerPackage> packages = new ArrayList<StickerPackage>();
        while (cursor.moveToNext()) {
            StickerPackage stickerPackage = StickerPackageTable.createStickerPackageFromCursor(cursor);
            packages.add(stickerPackage);
        }
        cursor.close();
        return packages;
    }

    public static boolean exist(SQLiteDatabase db, String packageId) {
        String sql = "SELECT _id FROM sticker_package WHERE packageId = ?";
        Cursor cursor = db.rawQuery(sql, new String[]{packageId});
        boolean exist = cursor.getCount() == 1;
        cursor.close();
        return exist;
    }

    public static void insert(SQLiteDatabase db, StickerPackage stickerPackage) {
        ContentValues cv = new ContentValues();
        cv.put(COLUMN_PACKAGE_ID, stickerPackage.getPackageId());
        cv.put(COLUMN_NAME, stickerPackage.getName());
        cv.put(COLUMN_PRELOAD, Integer.valueOf(stickerPackage.isPreload()));
        cv.put(COLUMN_AUTHOR, stickerPackage.getAuthor());
        cv.put(COLUMN_URL, stickerPackage.getUrl());
        cv.put(COLUMN_ICON, stickerPackage.getIcon());
        cv.put(COLUMN_COVER, stickerPackage.getCover());
        cv.put(COLUMN_COPYRIGHT, stickerPackage.getCopyright());
        cv.put(COLUMN_CREATE_TIME, stickerPackage.getCreateTime());
        cv.put(COLUMN_DIGEST, stickerPackage.getDigest());
        cv.put(COLUMN_ORDER, Integer.valueOf(stickerPackage.getOrder()));
        db.insert(NAME, null, cv);
    }

    public static void update(SQLiteDatabase db, StickerPackage stickerPackage) {
        ContentValues cv = new ContentValues();
        cv.put(COLUMN_PACKAGE_ID, stickerPackage.getPackageId());
        cv.put(COLUMN_NAME, stickerPackage.getName());
        cv.put(COLUMN_PRELOAD, Integer.valueOf(stickerPackage.isPreload()));
        cv.put(COLUMN_AUTHOR, stickerPackage.getAuthor());
        cv.put(COLUMN_URL, stickerPackage.getUrl());
        cv.put(COLUMN_ICON, stickerPackage.getIcon());
        cv.put(COLUMN_COVER, stickerPackage.getCover());
        cv.put(COLUMN_COPYRIGHT, stickerPackage.getCopyright());
        cv.put(COLUMN_CREATE_TIME, stickerPackage.getCreateTime());
        cv.put(COLUMN_DIGEST, stickerPackage.getDigest());
        cv.put(COLUMN_ORDER, Integer.valueOf(stickerPackage.getOrder()));
        String where = "packageId = ?";
        String[] whereArgs = new String[]{stickerPackage.getPackageId()};
        db.update(NAME, cv, where, whereArgs);
    }

    public static void setDownload(SQLiteDatabase db, String packageId, boolean isDownload) {
        ContentValues cv = new ContentValues();
        cv.put(COLUMN_IS_DOWNLOAD, Boolean.valueOf(isDownload));
        String selection = "packageId = ?";
        String[] selectionArgs = new String[]{packageId};
        db.update(NAME, cv, selection, selectionArgs);
    }

    public static boolean isDownload(SQLiteDatabase db, String packageId) {
        String sql = "SELECT * FROM sticker_package WHERE packageId = ? AND is_download = 1";
        Cursor cursor = db.rawQuery(sql, new String[]{packageId});
        boolean download = cursor.getCount() == 1;
        cursor.close();
        return download;
    }

    public static List<StickerPackage> getRecommendPackages(SQLiteDatabase db) {
        String sql = "SELECT * FROM sticker_package WHERE preload = 0 AND is_download = 0";
        Cursor cursor = db.rawQuery(sql, null);
        ArrayList<StickerPackage> list = new ArrayList<StickerPackage>();
        while (cursor.moveToNext()) {
            StickerPackage stickerPackage = StickerPackageTable.createStickerPackageFromCursor(cursor);
            list.add(stickerPackage);
        }
        return list;
    }

    public static List<StickerPackage> getDownloadPackages(SQLiteDatabase db) {
        String sql = "SELECT * FROM sticker_package WHERE is_download = 1";
        Cursor cursor = db.rawQuery(sql, null);
        ArrayList<StickerPackage> list = new ArrayList<StickerPackage>();
        while (cursor.moveToNext()) {
            StickerPackage stickerPackage = StickerPackageTable.createStickerPackageFromCursor(cursor);
            list.add(stickerPackage);
        }
        return list;
    }

    private static StickerPackage createStickerPackageFromCursor(Cursor cursor) {
        ArrayList<String> columns = new ArrayList<String>();
        for (int i = 0; i < cursor.getColumnCount(); ++i) {
            columns.add(cursor.getColumnName(i));
        }
        StickerPackage stickerPackage = new StickerPackage();
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            String column;
            switch (column = (String)iterator.next()) {
                case "packageId": {
                    stickerPackage.setPackageId(cursor.getString(cursor.getColumnIndex(column)));
                    break;
                }
                case "name": {
                    stickerPackage.setName(cursor.getString(cursor.getColumnIndex(column)));
                    break;
                }
                case "preload": {
                    stickerPackage.setPreload(cursor.getInt(cursor.getColumnIndex(column)));
                    break;
                }
                case "author": {
                    stickerPackage.setAuthor(cursor.getString(cursor.getColumnIndex(column)));
                    break;
                }
                case "url": {
                    stickerPackage.setUrl(cursor.getString(cursor.getColumnIndex(column)));
                    break;
                }
                case "icon": {
                    stickerPackage.setIcon(cursor.getString(cursor.getColumnIndex(column)));
                    break;
                }
                case "cover": {
                    stickerPackage.setCover(cursor.getString(cursor.getColumnIndex(column)));
                    break;
                }
                case "copyright": {
                    stickerPackage.setCopyright(cursor.getString(cursor.getColumnIndex(column)));
                    break;
                }
                case "createTime": {
                    stickerPackage.setCreateTime(cursor.getString(cursor.getColumnIndex(column)));
                    break;
                }
                case "digest": {
                    stickerPackage.setDigest(cursor.getString(cursor.getColumnIndex(column)));
                    break;
                }
                case "packageOrder": {
                    stickerPackage.setOrder(cursor.getInt(cursor.getColumnIndex(column)));
                    break;
                }
                case "is_download": {
                    stickerPackage.setDownload(cursor.getInt(cursor.getColumnIndex(column)) == 1);
                }
            }
        }
        return stickerPackage;
    }
}

