/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sticker.db;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import java.io.File;

public class StickerDbHelper
extends SQLiteOpenHelper {
    private static final String DB_NAME = "Sticker.db";
    private static final int DB_VERSION = 1;
    private static volatile StickerDbHelper instance;
    private static String sDbPath;

    public static void init(Context context, String appKey, String userId) {
        String dbPath = StickerDbHelper.getDbPath(context, appKey, userId);
        if (!dbPath.equals(sDbPath) || instance == null) {
            sDbPath = dbPath;
            instance = new StickerDbHelper(context);
        }
    }

    public static void destroy() {
        if (instance != null) {
            instance.close();
            instance = null;
        }
    }

    private static String getDbPath(Context context, String appKey, String userId) {
        String[] pathArray = new String[]{context.getFilesDir().toString(), appKey, userId, DB_NAME};
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < pathArray.length; ++i) {
            sb.append(pathArray[i]);
            if (i >= pathArray.length - 1) continue;
            sb.append(File.separator);
        }
        return sb.toString();
    }

    public static StickerDbHelper getInstance() {
        return instance;
    }

    private StickerDbHelper(Context context) {
        super(context.getApplicationContext(), sDbPath, null, 1);
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE sticker_package (_id INTEGER PRIMARY KEY, packageId TEXT UNIQUE, name TEXT, preload INTEGER, author TEXT, url TEXT, icon TEXT, cover TEXT, copyright TEXT, createTime INTEGER, digest TEXT, packageOrder INTEGER, is_download BOOLEAN DEFAULT 0)");
        db.execSQL("CREATE TABLE sticker (_id INTEGER PRIMARY KEY, stickerId TEXT, packageId TEXT, digest TEXT, thumbUrl TEXT, url TEXT, stickerOrder TEXT, localThumbUrl TEXT, localUrl TEXT, width INTEGER, height INTEGER)");
        db.execSQL("CREATE TABLE preload_sticker_package_delete (packageId TEXT PRIMARY KEY, isDelete BOOLEAN)");
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
    }
}

