/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sticker.businesslogic;

import android.content.Context;
import com.google.gson.Gson;
import io.rong.sticker.businesslogic.PreloadPackageDownloadTask;
import io.rong.sticker.businesslogic.StickerPackageApiTask;
import io.rong.sticker.businesslogic.StickerPackageDbTask;
import io.rong.sticker.businesslogic.StickerPackageStorageTask;
import io.rong.sticker.model.StickerPackagesConfigInfo;
import io.rong.sticker.util.HttpUtil;

public class StickerPackagesConfigTask {
    private StickerPackagesConfigInfo mInfo;

    public void getConfig() {
        StickerPackageApiTask.getAllConfig(new HttpUtil.Callback<StickerPackagesConfigInfo>(){

            @Override
            public void onSuccess(StickerPackagesConfigInfo result) {
                StickerPackagesConfigTask.this.mInfo = result;
            }

            @Override
            public void onError(Exception e) {
            }
        });
    }

    public void saveConfig(Context context) {
        this.saveStickerPackagesInfo();
        this.refreshInfo();
        if (this.mInfo != null) {
            PreloadPackageDownloadTask task = new PreloadPackageDownloadTask(context, this.mInfo.getPreload());
            task.execute();
        }
    }

    private void refreshInfo() {
        StickerPackageApiTask.getAllConfig(new HttpUtil.Callback<StickerPackagesConfigInfo>(){

            @Override
            public void onSuccess(StickerPackagesConfigInfo result) {
                StickerPackagesConfigTask.this.mInfo = result;
                StickerPackagesConfigTask.this.saveStickerPackagesInfo();
            }

            @Override
            public void onError(Exception e) {
            }
        });
    }

    private void saveStickerPackagesInfo() {
        if (this.mInfo != null) {
            String json = new Gson().toJson((Object)this.mInfo);
            StickerPackageStorageTask.saveStickerPackagesConfig(json);
            StickerPackageDbTask.getInstance().savePackages(this.mInfo.getPreload());
            StickerPackageDbTask.getInstance().savePackages(this.mInfo.getManualLoad());
        }
    }
}

