/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sticker.businesslogic;

import android.content.Context;
import io.rong.eventbus.EventBus;
import io.rong.sticker.businesslogic.StickerPackageApiTask;
import io.rong.sticker.businesslogic.StickerPackageDbTask;
import io.rong.sticker.businesslogic.StickerPackageIconDownloadTask;
import io.rong.sticker.businesslogic.StickerPackageStorageTask;
import io.rong.sticker.model.Event;
import io.rong.sticker.model.StickerPackage;
import io.rong.sticker.model.StickerPackageDownloadUrlInfo;
import io.rong.sticker.util.DownloadUtil;
import io.rong.sticker.util.HttpUtil;
import io.rong.sticker.util.ZipUtil;

public class StickerPackageDownloadTask {
    private String packageId;

    public StickerPackageDownloadTask(Context context, String packageId) {
        this.packageId = packageId;
    }

    public void downloadStickerPackage(final DownloadUtil.DownloadListener listener) {
        StickerPackageApiTask.getStickerPackageDownloadUrl(this.packageId, new HttpUtil.Callback<StickerPackageDownloadUrlInfo>(){

            @Override
            public void onSuccess(StickerPackageDownloadUrlInfo result) {
                DownloadUtil downloadUtil = new DownloadUtil(result.getDownloadUrl());
                String savePath = StickerPackageStorageTask.getStickerHomeDir() + StickerPackageDownloadTask.this.packageId + ".zip";
                downloadUtil.addDownloadListener(listener);
                downloadUtil.download(savePath);
                StickerPackageDownloadTask.this.unzip(savePath);
            }

            @Override
            public void onError(Exception e) {
                listener.onError(e);
            }
        });
    }

    private void unzip(String zipFilePath) {
        ZipUtil.unzip(zipFilePath);
        StickerPackage stickerPackage = StickerPackageStorageTask.loadStickerPackage(this.packageId);
        new StickerPackageIconDownloadTask(stickerPackage).execute();
        StickerPackageDbTask.getInstance().setPackageDownload(stickerPackage);
        EventBus.getDefault().post((Object)new Event.AddPackageEvent(stickerPackage));
    }
}

