/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sticker.businesslogic;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import io.rong.sticker.db.PreloadStickerPackageDeleteTable;
import io.rong.sticker.db.StickerDbHelper;
import io.rong.sticker.db.StickerPackageTable;
import io.rong.sticker.db.StickerTable;
import io.rong.sticker.model.Sticker;
import io.rong.sticker.model.StickerPackage;
import java.util.List;

public class StickerPackageDbTask {
    private SQLiteDatabase db;
    private static StickerPackageDbTask instance;

    private StickerPackageDbTask() {
        StickerDbHelper dbManager = StickerDbHelper.getInstance();
        this.db = dbManager.getWritableDatabase();
    }

    public static void init(Context context, String appKey, String userId) {
        StickerDbHelper.init(context, appKey, userId);
    }

    public static void destroy() {
        StickerDbHelper.destroy();
        instance = null;
    }

    public static synchronized StickerPackageDbTask getInstance() {
        if (instance == null) {
            instance = new StickerPackageDbTask();
        }
        return instance;
    }

    private void savePackage(StickerPackage stickerPackage) {
        if (StickerPackageTable.exist(this.db, stickerPackage.getPackageId())) {
            StickerPackageTable.update(this.db, stickerPackage);
        } else {
            StickerPackageTable.insert(this.db, stickerPackage);
        }
    }

    public void setPackageDownload(StickerPackage stickerPackage) {
        StickerPackageTable.setDownload(this.db, stickerPackage.getPackageId(), stickerPackage.isDownload());
        this.saveStickers(stickerPackage);
        if (stickerPackage.isPreload() == 1) {
            PreloadStickerPackageDeleteTable.update(this.db, stickerPackage.getPackageId(), false);
        }
    }

    public boolean isPreloadPackageNeedDownload(String packageId) {
        return !StickerPackageDbTask.getInstance().isPackageDownload(packageId) && !StickerPackageDbTask.getInstance().isPreloadPackageDeleted(packageId);
    }

    private boolean isPackageDownload(String packageId) {
        return StickerPackageTable.isDownload(this.db, packageId);
    }

    private boolean isPreloadPackageDeleted(String packageId) {
        return PreloadStickerPackageDeleteTable.isDelete(this.db, packageId);
    }

    public void savePackages(List<StickerPackage> stickerPackages) {
        if (stickerPackages != null) {
            for (StickerPackage stickerPackage : stickerPackages) {
                this.savePackage(stickerPackage);
            }
        }
    }

    public void deletePackage(String packageId, boolean isPreload) {
        StickerTable.deleteByPackageId(this.db, packageId);
        StickerPackageTable.setDownload(this.db, packageId, false);
        if (isPreload) {
            PreloadStickerPackageDeleteTable.update(this.db, packageId, true);
        }
    }

    public List<StickerPackage> getDownloadPackages() {
        return StickerPackageTable.getDownloadPackages(this.db);
    }

    public List<StickerPackage> getRecommendPackages() {
        return StickerPackageTable.getRecommendPackages(this.db);
    }

    private void saveSticker(String packageId, Sticker sticker) {
        StickerTable.insert(this.db, packageId, sticker);
    }

    private void saveStickers(StickerPackage stickerPackage) {
        List<Sticker> stickers = stickerPackage.getStickers();
        for (Sticker sticker : stickers) {
            this.saveSticker(stickerPackage.getPackageId(), sticker);
        }
    }

    public List<StickerPackage> getStickerPackages() {
        List<StickerPackage> packages = StickerPackageTable.getAllPackages(this.db);
        for (StickerPackage stickerPackage : packages) {
            List<Sticker> stickers = StickerTable.getStickersByPackageId(this.db, stickerPackage.getPackageId());
            stickerPackage.setStickers(stickers);
        }
        return packages;
    }
}

