/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sticker.businesslogic;

import android.support.annotation.Nullable;
import io.rong.sticker.model.Sticker;
import io.rong.sticker.model.StickerPackageDownloadUrlInfo;
import io.rong.sticker.model.StickerPackagesConfigInfo;
import io.rong.sticker.util.HttpUtil;
import io.rong.sticker.util.SHA1Util;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class StickerPackageApiTask {
    private static final String HOST = "https://stickerservice.ronghub.com/";
    private static final String ALL_CONFIG = "emoticonservice/emopkgs";
    private static final String PACKAGE_DOWNLOAD_URL = "emoticonservice/emopkgs/%s";
    private static final String GET_STICKER_URL = "emoticonservice/emopkgs/%s/stickers/%s";
    private static String sAppKey;
    private static ExecutorService service;

    public static void init(String appKey) {
        sAppKey = appKey;
    }

    public static void getAllConfig(HttpUtil.Callback<StickerPackagesConfigInfo> callback) {
        String url = StickerPackageApiTask.getUrl(ALL_CONFIG);
        service.submit(new Worker<StickerPackagesConfigInfo>(url, callback));
    }

    public static void getStickerPackageDownloadUrl(String packageId, HttpUtil.Callback<StickerPackageDownloadUrlInfo> callback) {
        String s = String.format(PACKAGE_DOWNLOAD_URL, packageId);
        String url = StickerPackageApiTask.getUrl(s);
        service.submit(new Worker<StickerPackageDownloadUrlInfo>(url, callback));
    }

    @Nullable
    public static Sticker getStickerSync(String packageId, String stickerId) {
        String s = String.format(GET_STICKER_URL, packageId, stickerId);
        String url = StickerPackageApiTask.getUrl(s);
        try {
            return (Sticker)HttpUtil.get(url, StickerPackageApiTask.createHeader(), Sticker.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getUrl(String api) {
        return HOST + api;
    }

    private static Map<String, String> createHeader() {
        HashMap<String, String> map = new HashMap<String, String>();
        String nonce = Integer.toString(new Random().nextInt(10000));
        String timestamp = Long.toString(System.currentTimeMillis());
        String signature = SHA1Util.SHA1(SHA1Util.SHA1(sAppKey) + nonce + timestamp);
        map.put("AppKey", sAppKey);
        map.put("Nonce", nonce);
        map.put("Timestamp", timestamp);
        map.put("Signature", signature);
        return map;
    }

    static {
        service = Executors.newCachedThreadPool();
    }

    private static class Worker<T>
    implements Runnable {
        private String url;
        private HttpUtil.Callback<T> callback;

        Worker(String url, HttpUtil.Callback<T> callback) {
            this.url = url;
            this.callback = callback;
        }

        @Override
        public void run() {
            HttpUtil.get(this.url, (Map<String, String>)StickerPackageApiTask.createHeader(), this.callback);
        }
    }
}

