/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sticker.businesslogic;

import io.rong.sticker.businesslogic.StickerPackageApiTask;
import io.rong.sticker.businesslogic.StickerPackageStorageTask;
import io.rong.sticker.model.Sticker;
import io.rong.sticker.util.DownloadUtil;

public class StickerDownloadTask {
    private String packageId;
    private String stickerId;

    StickerDownloadTask(String packageId, String stickerId) {
        this.packageId = packageId;
        this.stickerId = stickerId;
    }

    public void downloadSticker() {
        Sticker sticker = StickerPackageApiTask.getStickerSync(this.packageId, this.stickerId);
        if (sticker != null) {
            DownloadUtil downloadThumb = new DownloadUtil(sticker.getThumbUrl());
            String savePath = StickerPackageStorageTask.getStickerThumbFilePath(this.packageId, this.stickerId);
            downloadThumb.download(savePath);
            sticker.setLocalThumbUrl(savePath);
            DownloadUtil downloadImage = new DownloadUtil(sticker.getUrl());
            savePath = StickerPackageStorageTask.getStickerImageFilePath(this.packageId, this.stickerId);
            downloadImage.download(savePath);
            sticker.setLocalUrl(savePath);
        }
    }
}

