/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sticker.businesslogic;

import android.os.Handler;
import android.util.LruCache;
import io.rong.sticker.businesslogic.StickerDownloadTask;
import io.rong.sticker.businesslogic.StickerPackageStorageTask;
import io.rong.sticker.businesslogic.StickerPackagesUiHandler;
import io.rong.sticker.message.StickerMessage;
import io.rong.sticker.model.Sticker;
import io.rong.sticker.util.FileUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class GifImageLoader {
    private static final String SEPARATOR = " ";
    private static final int CACHE_SIZE = 0x500000;
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private LruCache<String, byte[]> cache = new LruCache<String, byte[]>(0x500000){

        protected int sizeOf(String key, byte[] bytes) {
            return bytes.length;
        }

        protected synchronized byte[] create(String key) {
            String[] strings = key.split(GifImageLoader.SEPARATOR);
            String packageId = strings[0];
            String stickerId = strings[1];
            return FileUtil.toByteArray(StickerPackageStorageTask.getStickerImageFilePath(packageId, stickerId));
        }
    };
    private static GifImageLoader instance;

    public static synchronized GifImageLoader getInstance() {
        if (instance == null) {
            instance = new GifImageLoader();
        }
        return instance;
    }

    private GifImageLoader() {
    }

    public void obtain(Sticker sticker, SimpleCallback callback) {
        Worker worker = new Worker(sticker, (Callback)callback);
        this.executorService.submit(worker);
    }

    public void obtain(StickerMessage stickerMessage, SimpleCallback callback) {
        Worker worker = new Worker(stickerMessage, (Callback)callback);
        this.executorService.submit(worker);
    }

    public void clear() {
        this.cache.evictAll();
    }

    public static abstract class SimpleCallback
    implements Callback {
        @Override
        public void onResult(final byte[] bytes) {
            Handler handler = StickerPackagesUiHandler.getUiHandler();
            if (handler != null) {
                if (bytes != null) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            SimpleCallback.this.onSuccess(bytes);
                        }
                    });
                } else {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            SimpleCallback.this.onFail();
                        }
                    });
                }
            }
        }

        public abstract void onSuccess(byte[] var1);

        public abstract void onFail();
    }

    public static interface Callback {
        public void onResult(byte[] var1);
    }

    private class Worker
    implements Runnable {
        private String packageId;
        private String stickerId;
        private Callback callback;

        Worker(StickerMessage stickerMessage, Callback callback) {
            this.packageId = stickerMessage.getPackageId();
            this.stickerId = stickerMessage.getStickerId();
            this.callback = callback;
        }

        Worker(Sticker sticker, Callback callback) {
            this.packageId = sticker.getPackageId();
            this.stickerId = sticker.getStickerId();
            this.callback = callback;
        }

        @Override
        public void run() {
            if (!StickerPackageStorageTask.isStickerExist(this.packageId, this.stickerId)) {
                StickerDownloadTask task = new StickerDownloadTask(this.packageId, this.stickerId);
                task.downloadSticker();
            }
            byte[] bytes = (byte[])GifImageLoader.this.cache.get((Object)this.createKey());
            this.callback.onResult(bytes);
        }

        private String createKey() {
            return this.packageId + GifImageLoader.SEPARATOR + this.stickerId;
        }
    }
}

