/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sticker;

import android.content.Context;
import android.content.Intent;
import android.view.View;
import io.rong.eventbus.EventBus;
import io.rong.imkit.IExtensionModule;
import io.rong.imkit.RongExtension;
import io.rong.imkit.RongIM;
import io.rong.imkit.emoticon.IEmoticonSettingClickListener;
import io.rong.imkit.emoticon.IEmoticonTab;
import io.rong.imkit.plugin.IPluginModule;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import io.rong.sticker.businesslogic.GifImageLoader;
import io.rong.sticker.businesslogic.StickerPackageApiTask;
import io.rong.sticker.businesslogic.StickerPackageDbTask;
import io.rong.sticker.businesslogic.StickerPackageSortTask;
import io.rong.sticker.businesslogic.StickerPackageStorageTask;
import io.rong.sticker.businesslogic.StickerPackagesConfigTask;
import io.rong.sticker.businesslogic.StickerPackagesUiHandler;
import io.rong.sticker.businesslogic.StickerSendMessageTask;
import io.rong.sticker.emoticontab.RecommendTab;
import io.rong.sticker.emoticontab.StickersTab;
import io.rong.sticker.message.StickerMessage;
import io.rong.sticker.message.StickerMessageItemProvider;
import io.rong.sticker.model.Event;
import io.rong.sticker.model.StickerPackage;
import io.rong.sticker.mysticker.MyStickerActivity;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class StickerExtensionModule
implements IExtensionModule {
    private static final String TAG = StickerExtensionModule.class.getCanonicalName();
    private static String sAppKey;
    private static WeakReference<RongExtension> sRongExtensionWeakReference;
    private RecommendTab recommendTab;
    private List<WeakReference<StickersTab>> tabList;
    private StickerPackagesConfigTask stickerPackagesConfigTask;
    private boolean isEnabled = true;

    public void onInit(String appKey) {
        sAppKey = appKey;
        RongIM.registerMessageType(StickerMessage.class);
        RongIM.registerMessageTemplate((IContainerItemProvider.MessageProvider)new StickerMessageItemProvider());
        StickerPackageApiTask.init(appKey);
        this.stickerPackagesConfigTask = new StickerPackagesConfigTask();
        this.stickerPackagesConfigTask.getConfig();
    }

    public void onConnect(String token) {
    }

    public void onAttachedToExtension(RongExtension extension) {
        if (extension.getConversationType().getName().equals(Conversation.ConversationType.CUSTOMER_SERVICE.getName())) {
            this.isEnabled = false;
        } else {
            this.isEnabled = true;
            sRongExtensionWeakReference = new WeakReference<RongExtension>(extension);
            this.tabList = new ArrayList<WeakReference<StickersTab>>();
            if (!EventBus.getDefault().isRegistered((Object)this)) {
                EventBus.getDefault().register((Object)this);
            }
            Context context = extension.getContext();
            StickerPackageDbTask.init(context, sAppKey, RongIM.getInstance().getCurrentUserId());
            StickerPackagesUiHandler.init(context);
            StickerPackageStorageTask.init(context, sAppKey, RongIM.getInstance().getCurrentUserId());
            this.stickerPackagesConfigTask.saveConfig(context);
            StickerSendMessageTask.config(extension.getTargetId(), extension.getConversationType());
        }
    }

    public void onDetachedFromExtension() {
        if (this.isEnabled) {
            sRongExtensionWeakReference = null;
            this.recommendTab = null;
            EventBus.getDefault().unregister((Object)this);
            GifImageLoader.getInstance().clear();
            StickerPackagesUiHandler.destroy();
            this.tabList.clear();
        }
    }

    public void onReceivedMessage(Message message) {
    }

    public List<IPluginModule> getPluginModules(Conversation.ConversationType conversationType) {
        return null;
    }

    public List<IEmoticonTab> getEmoticonTabs() {
        if (sRongExtensionWeakReference == null) {
            return null;
        }
        RongExtension rongExtension = (RongExtension)sRongExtensionWeakReference.get();
        if (rongExtension == null) {
            return null;
        }
        if (!this.isEnabled) {
            return null;
        }
        ArrayList<IEmoticonTab> list = new ArrayList<IEmoticonTab>();
        List<StickerPackage> packages = StickerPackageDbTask.getInstance().getStickerPackages();
        ArrayList<StickerPackage> downloadPackages = new ArrayList<StickerPackage>();
        ArrayList<StickerPackage> recommendPackages = new ArrayList<StickerPackage>();
        for (StickerPackage stickerPackage : packages) {
            if (stickerPackage.isDownload()) {
                downloadPackages.add(stickerPackage);
                continue;
            }
            if (stickerPackage.isPreload() != 0) continue;
            recommendPackages.add(stickerPackage);
        }
        if (!recommendPackages.isEmpty()) {
            this.recommendTab = new RecommendTab(recommendPackages);
            list.add(this.recommendTab);
        }
        for (StickerPackage downloadPackage : downloadPackages) {
            StickersTab tab = new StickersTab(downloadPackage);
            this.tabList.add(new WeakReference<StickersTab>(tab));
            list.add(tab);
        }
        rongExtension.setEmoticonTabBarSettingEnable(true);
        rongExtension.setEmoticonTabBarSettingClickListener((IEmoticonSettingClickListener)new SettingClickListener());
        return list;
    }

    public void onDisconnect() {
        StickerPackageDbTask.destroy();
    }

    public void onEventMainThread(Event.AddPackageEvent event) {
        RongExtension rongExtension;
        if (sRongExtensionWeakReference != null && (rongExtension = (RongExtension)sRongExtensionWeakReference.get()) != null) {
            StickerPackage stickerPackage = event.getStickerPackage();
            StickersTab stickersTab = new StickersTab(stickerPackage);
            int index = StickerPackageSortTask.getInsertIndex(this.tabList, stickerPackage);
            this.tabList.add(index, new WeakReference<StickersTab>(stickersTab));
            rongExtension.addEmoticonTab(index + 1, (IEmoticonTab)stickersTab, TAG);
            rongExtension.setCurrentEmoticonTab((IEmoticonTab)stickersTab, TAG);
            if (this.recommendTab != null && stickerPackage.isPreload() == 0) {
                this.recommendTab.removePackage(stickerPackage);
                if (this.recommendTab.isEmpty()) {
                    rongExtension.removeEmoticonTab((IEmoticonTab)this.recommendTab, TAG);
                    this.recommendTab = null;
                }
            }
        }
    }

    public void onEventMainThread(Event.RemovePackageEvent event) {
        RongExtension rongExtension;
        if (sRongExtensionWeakReference != null && (rongExtension = (RongExtension)sRongExtensionWeakReference.get()) != null) {
            for (WeakReference<StickersTab> tabWeakReference : this.tabList) {
                StickersTab tab = (StickersTab)tabWeakReference.get();
                if (!tab.getStickerPackage().getPackageId().equals(event.getPackageId())) continue;
                this.tabList.remove(tabWeakReference);
                rongExtension.removeEmoticonTab((IEmoticonTab)tab, TAG);
                break;
            }
            List<StickerPackage> notDownloadPackages = StickerPackageDbTask.getInstance().getRecommendPackages();
            if (this.recommendTab == null) {
                this.recommendTab = new RecommendTab(notDownloadPackages);
                rongExtension.addEmoticonTab((IEmoticonTab)this.recommendTab, TAG);
            } else {
                this.recommendTab.setPackages(notDownloadPackages);
            }
        }
    }

    private static class SettingClickListener
    implements IEmoticonSettingClickListener {
        private SettingClickListener() {
        }

        public void onSettingClick(View view) {
            RongExtension rongExtension;
            if (sRongExtensionWeakReference != null && (rongExtension = (RongExtension)sRongExtensionWeakReference.get()) != null && rongExtension.getContext() != null) {
                Intent intent = new Intent(rongExtension.getContext(), MyStickerActivity.class);
                rongExtension.getContext().startActivity(intent);
            }
        }
    }
}

