/*
 * Decompiled with CFR 0.152.
 */
package io.rong.rtlog.upload;

import android.text.TextUtils;
import io.rong.common.rlog.RLog;
import io.rong.imlib.common.NetUtils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.zip.GZIPOutputStream;

public abstract class UploadLogTask {
    private static final String TAG = UploadLogTask.class.getSimpleName();
    private static final String BOUNDARY = "03297e90-eed0-4cec-b18b-92d2574b9331";
    protected static final String URL_ENCODE_CHARSET = "utf-8";

    protected abstract String getUploadUrl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean upload(String uploadFilePath) {
        HttpURLConnection conn = null;
        FilterOutputStream outStream = null;
        InputStream inStream = null;
        boolean result = false;
        FileInputStream fileInputStream = null;
        File uploadFile = null;
        try {
            String line;
            int len;
            uploadFile = new File(uploadFilePath);
            conn = NetUtils.createURLConnection(this.getUploadUrl());
            conn.setConnectTimeout(15000);
            conn.setReadTimeout(5000);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=03297e90-eed0-4cec-b18b-92d2574b9331");
            outStream = new DataOutputStream(conn.getOutputStream());
            ((DataOutputStream)outStream).writeBytes("--03297e90-eed0-4cec-b18b-92d2574b9331\r\n");
            ((DataOutputStream)outStream).writeBytes("Content-Disposition: form-data; name=\"fileLog\"; filename=\"fileLog.gz\"\r\n");
            ((DataOutputStream)outStream).writeBytes("Content-Type: application/octet-stream\r\n\r\n");
            byte[] buffer = new byte[1024];
            fileInputStream = new FileInputStream(uploadFile);
            GZIPOutputStream gzStream = new GZIPOutputStream(outStream);
            while ((len = fileInputStream.read(buffer)) > 0) {
                gzStream.write(buffer, 0, len);
            }
            gzStream.finish();
            ((DataOutputStream)outStream).writeBytes("\r\n--03297e90-eed0-4cec-b18b-92d2574b9331--\r\n");
            ((DataOutputStream)outStream).flush();
            inStream = conn.getInputStream();
            BufferedReader buff = new BufferedReader(new InputStreamReader(inStream));
            StringBuilder responseSb = new StringBuilder();
            while ((line = buff.readLine()) != null) {
                responseSb.append(line);
            }
            String response = responseSb.toString();
            int responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                if (!TextUtils.isEmpty((CharSequence)response)) {
                    this.onUploadResponse(response);
                }
                result = true;
            }
        }
        catch (Exception e) {
            RLog.e(TAG, "upload", e);
        }
        finally {
            boolean delete;
            if (conn != null) {
                conn.disconnect();
            }
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException ignored) {
                RLog.e(TAG, "outStream", ignored);
            }
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException ignored) {
                RLog.e(TAG, "inStream", ignored);
            }
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException ignored) {
                RLog.e(TAG, "fileInputStream", ignored);
            }
            if (uploadFile != null && uploadFile.exists() && !(delete = uploadFile.delete())) {
                RLog.d(TAG, "upload cache file delete return false.file name:" + uploadFile.getName());
            }
        }
        return result;
    }

    protected String encodeParams(String params) {
        String encodeParams;
        if (TextUtils.isEmpty((CharSequence)params)) {
            return params;
        }
        try {
            encodeParams = URLEncoder.encode(params, URL_ENCODE_CHARSET);
        }
        catch (UnsupportedEncodingException ignore) {
            encodeParams = params;
        }
        return encodeParams;
    }

    protected abstract void onUploadResponse(String var1);
}

