/*
 * Decompiled with CFR 0.152.
 */
package io.rong.rtlog.upload;

import android.content.Context;
import io.rong.common.rlog.RLog;
import io.rong.imlib.common.DeviceUtils;
import io.rong.imlib.navigation.NavigationCacheHelper;
import io.rong.rtlog.RtCronListener;
import io.rong.rtlog.upload.RtLogNativeProxy;
import io.rong.rtlog.upload.UploadLogTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public class TimingUploadLogTask
extends UploadLogTask {
    private static final String TAG = TimingUploadLogTask.class.getSimpleName();
    private static final String TIMING_UPLOAD_URL_FORMAT = "%s?version=%s&appkey=%s&userId=%s&deviceId=%s&deviceInfo=%s&platform=Android";
    private Context context;
    private String version;
    private String deviceId;
    private String appKey;
    private String uploadUrl;
    private int uploadLevel;
    private String queryFromTable;
    private String queryToTable;
    private int queryEndRecordId;
    private String uploadResponse;
    private String logCacheDir;

    public TimingUploadLogTask(Context context, String version, String deviceId, String appKey, int logLevel, String uploadUrl, String logCacheDir) {
        this.context = context;
        this.version = version;
        this.deviceId = deviceId;
        this.appKey = appKey;
        this.uploadLevel = logLevel;
        this.uploadUrl = uploadUrl;
        this.logCacheDir = logCacheDir;
    }

    public boolean execute() {
        String outputLogCachePath = this.getLogFile();
        if (outputLogCachePath == null) {
            return false;
        }
        File uploadLog = new File(outputLogCachePath);
        if (uploadLog.exists() && uploadLog.length() == 0L) {
            boolean delete = uploadLog.delete();
            if (delete) {
                RLog.d(TAG, "upload file is empty,so do not upload and delete it.");
            }
            return true;
        }
        boolean upload = this.upload(outputLogCachePath);
        if (upload) {
            RtLogNativeProxy.reportTimingUploadFinished(this.queryFromTable, this.queryToTable, this.queryEndRecordId, System.currentTimeMillis());
        }
        return upload;
    }

    @Override
    protected String getUploadUrl() {
        String userId = this.getLocalUserId();
        return String.format(TIMING_UPLOAD_URL_FORMAT, this.uploadUrl, this.encodeParams(this.version), this.encodeParams(this.appKey), this.encodeParams(userId), this.encodeParams(this.deviceId), this.encodeParams(DeviceUtils.getDeviceBandModelVersion()));
    }

    private String getLocalUserId() {
        return NavigationCacheHelper.getUserId(this.context);
    }

    @Override
    protected void onUploadResponse(String response) {
        this.uploadResponse = response;
    }

    public String getUploadResponse() {
        return this.uploadResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLogFile() {
        boolean mkLogDirResult;
        final CountDownLatch logReadLatch = new CountDownLatch(1);
        if (this.logCacheDir == null) {
            return null;
        }
        File logFile = new File(this.logCacheDir, "t_" + System.currentTimeMillis() + "_log_cache");
        if (!logFile.getParentFile().exists() && !(mkLogDirResult = logFile.getParentFile().mkdirs())) {
            RLog.d(TAG, "getLogFile mkdirs return false");
        }
        final AtomicBoolean queryResult = new AtomicBoolean(false);
        FileOutputStream logFileInput = null;
        try {
            final FileOutputStream logFileInputRef = logFileInput = new FileOutputStream(logFile);
            RtLogNativeProxy.setQueryTimingLogListener(new RtCronListener(){

                @Override
                public void NotifyCron() {
                    ByteBuffer logReadBuffer = this.getByteBuffer();
                    logReadBuffer.flip();
                    int remaining = logReadBuffer.remaining();
                    byte[] buffer = new byte[remaining];
                    logReadBuffer.get(buffer);
                    logReadBuffer.clear();
                    String log = new String(buffer).trim() + "\r\n";
                    try {
                        logFileInputRef.write(log.getBytes());
                    }
                    catch (IOException e) {
                        RLog.e(TAG, "getLogFile write log error", e);
                    }
                    logReadBuffer.clear();
                }

                @Override
                public void NotifyCronEnd(int result, String first_table_name, String last_table_name, int last_record_id) {
                    if (result == 0) {
                        queryResult.set(true);
                        TimingUploadLogTask.this.queryFromTable = first_table_name;
                        TimingUploadLogTask.this.queryToTable = last_table_name;
                        TimingUploadLogTask.this.queryEndRecordId = last_record_id;
                    } else {
                        RLog.e(TAG, "getLogFile NotifyFullEnd result:" + result);
                    }
                    logReadLatch.countDown();
                }
            });
            RtLogNativeProxy.queryTimingLog(this.uploadLevel);
            logReadLatch.await();
            logFileInput.flush();
            if (queryResult.get()) {
                String string2 = logFile.getAbsolutePath();
                return string2;
            }
            String string3 = null;
            return string3;
        }
        catch (InterruptedException e) {
            RLog.e(TAG, "getLogFile", e);
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            RLog.e(TAG, "getLogFile", e);
        }
        finally {
            if (logFileInput != null) {
                try {
                    logFileInput.close();
                }
                catch (IOException e) {}
            }
            if (!queryResult.get() && logFile.exists()) {
                boolean delete = logFile.delete();
                RLog.i(TAG, "delete result is " + delete);
            }
        }
        return null;
    }
}

