/*
 * Decompiled with CFR 0.152.
 */
package io.rong.rtlog.upload;

import android.annotation.SuppressLint;
import android.content.Context;
import io.rong.common.rlog.RLog;
import io.rong.rtlog.RtCronListener;
import io.rong.rtlog.RtFullListener;
import io.rong.rtlog.RtLogNative;

class RtLogNativeProxy {
    private static final String TAG = RtLogNativeProxy.class.getSimpleName();
    private RtLogNative nativeObject = new RtLogNative();

    private RtLogNativeProxy() {
    }

    public static RtLogNativeProxy getInstance() {
        return SingletonHolder.instance;
    }

    public static boolean initialize(Context context, String dbParentPath, String appKey, String sessionId) {
        RtLogNative nativeObject = SingletonHolder.instance.nativeObject;
        boolean result = false;
        try {
            result = nativeObject.initialize(dbParentPath, appKey, sessionId) == 0;
        }
        catch (Exception e) {
            RLog.d(TAG, "initialize - native call exception :" + e.toString());
        }
        return result;
    }

    public static void writeLog(int level, String type, String tag, String content, long timeStamp) {
        try {
            SingletonHolder.instance.nativeObject.writeMessage(level, type, tag, content, timeStamp);
        }
        catch (Exception e) {
            RLog.d(TAG, "writeLog - native call exception :" + e.toString());
        }
    }

    public static boolean queryTimingLog(int level) {
        boolean result = false;
        try {
            result = SingletonHolder.instance.nativeObject.queryCronMessage(level, false) == 0;
        }
        catch (Exception e) {
            RLog.d(TAG, "queryTimingLog - native call exception :" + e.toString());
        }
        return result;
    }

    public static boolean queryFullLog(int level, long startTime, long endTime) {
        boolean result = false;
        try {
            result = SingletonHolder.instance.nativeObject.queryFullMessage(level, startTime, endTime, true) == 0;
        }
        catch (Exception e) {
            RLog.d(TAG, "queryFullLog - native call exception :" + e.toString());
        }
        return result;
    }

    public static void setQueryTimingLogListener(RtCronListener listener) {
        try {
            SingletonHolder.instance.nativeObject.setCronListener(listener);
        }
        catch (Exception e) {
            RLog.d(TAG, "setQueryTimingLogListener - native call exception :" + e.toString());
        }
    }

    public static void setQueryFullLogListener(RtFullListener listener) {
        try {
            SingletonHolder.instance.nativeObject.setFullListener(listener);
        }
        catch (Exception e) {
            RLog.d(TAG, "setQueryFullLogListener - native call exception :" + e.toString());
        }
    }

    public static boolean reportTimingUploadFinished(String fromTable, String toTable, int lastRecordId, long timeStamp) {
        boolean result = false;
        try {
            result = SingletonHolder.instance.nativeObject.updateCronUploadTime(fromTable, toTable, lastRecordId, timeStamp) == 0;
        }
        catch (Exception e) {
            RLog.d(TAG, "reportTimingUploadFinished - native call exception :" + e.toString());
        }
        return result;
    }

    private static class SingletonHolder {
        @SuppressLint(value={"StaticFieldLeak"})
        private static final RtLogNativeProxy instance = new RtLogNativeProxy();

        private SingletonHolder() {
        }
    }
}

