/*
 * Decompiled with CFR 0.152.
 */
package io.rong.rtlog.upload;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import io.rong.rtlog.upload.FullUploadLogCache;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

class RtLogCache {
    private Context context;
    private SharedPreferences preferences;
    private LinkedHashMap<String, FullUploadLogCache> fullUploadLogCacheMap = new LinkedHashMap();
    private volatile boolean isMapToSp;

    RtLogCache(Context context, String appKey) {
        this.context = context;
        this.preferences = context.getSharedPreferences("rt_log_cache_" + appKey, 0);
    }

    String loadTimingUploadConfigCache() {
        return this.preferences.getString("log_config", "default_config");
    }

    void saveTimingUploadConfig(String configJson) {
        SharedPreferences.Editor edit = this.preferences.edit();
        edit.putString("log_config", configJson);
        edit.apply();
    }

    List<FullUploadLogCache> loadFullUploadLogCacheList() {
        if (!this.isMapToSp) {
            this.isMapToSp = true;
            Set cacheCsvSet = this.preferences.getStringSet("full_log_cache", null);
            if (cacheCsvSet == null) {
                return new ArrayList<FullUploadLogCache>();
            }
            for (String cacheCsv : cacheCsvSet) {
                FullUploadLogCache cache = FullUploadLogCache.parseFromCSV(cacheCsv);
                if (cache == null || TextUtils.isEmpty((CharSequence)cache.getLogId())) continue;
                this.fullUploadLogCacheMap.put(cache.getLogId(), cache);
            }
        }
        return new ArrayList<FullUploadLogCache>(this.fullUploadLogCacheMap.values());
    }

    synchronized void addFullUploadTaskCache(String version, String deviceId, String appKey, String uri, String userId, String logId, long startTime, long endTime) {
        FullUploadLogCache cache = new FullUploadLogCache(version, deviceId, appKey, uri, userId, logId, startTime, endTime);
        this.fullUploadLogCacheMap.remove(cache.getLogId());
        this.fullUploadLogCacheMap.put(cache.getLogId(), cache);
        SharedPreferences.Editor edit = this.preferences.edit();
        edit.putStringSet("full_log_cache", this.convertFullUploadTaskCacheToCsvSet());
        edit.apply();
    }

    synchronized void removeFullUploadTaskCache(String logId) {
        this.fullUploadLogCacheMap.remove(logId);
        SharedPreferences.Editor edit = this.preferences.edit();
        edit.putStringSet("full_log_cache", this.convertFullUploadTaskCacheToCsvSet());
        edit.apply();
    }

    private Set<String> convertFullUploadTaskCacheToCsvSet() {
        HashSet<String> csvSet = new HashSet<String>();
        for (FullUploadLogCache cache : this.fullUploadLogCacheMap.values()) {
            csvSet.add(cache.toCSV());
        }
        return csvSet;
    }
}

