/*
 * Decompiled with CFR 0.152.
 */
package io.rong.rtlog.upload;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.util.Log;
import io.rong.common.fwlog.IFwLogConsolePrinter;

public class RtFwLogConsolePrinter
implements IFwLogConsolePrinter {
    private static final String LOG_TAG_FORMAT = "[RC:%s][%s]";
    private boolean isReleaseMode;

    public RtFwLogConsolePrinter(Context context) {
        ApplicationInfo info = context.getApplicationInfo();
        this.isReleaseMode = info == null || (info.flags & 2) == 0;
    }

    @Override
    public void printLog(long timestamp, int level, String type, String tag, String metaJson, int consolePrintLevel) {
        String logTag = String.format(LOG_TAG_FORMAT, tag, type);
        if (this.isReleaseMode && level > consolePrintLevel) {
            return;
        }
        switch (level) {
            case 0: 
            case 1: {
                Log.e((String)logTag, (String)metaJson);
                break;
            }
            case 2: {
                Log.w((String)logTag, (String)metaJson);
                break;
            }
            case 3: {
                Log.i((String)logTag, (String)metaJson);
                break;
            }
            case 4: {
                Log.d((String)logTag, (String)metaJson);
                break;
            }
        }
    }
}

