/*
 * Decompiled with CFR 0.152.
 */
package io.rong.rtlog.upload;

import io.rong.common.rlog.RLog;
import io.rong.imlib.common.DeviceUtils;
import io.rong.rtlog.RtFullListener;
import io.rong.rtlog.upload.RtLogNativeProxy;
import io.rong.rtlog.upload.UploadLogTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;

class FullUploadLogTask
extends UploadLogTask {
    private static final String TAG = FullUploadLogTask.class.getSimpleName();
    private static final String FULL_UPLOAD_URL_FORMAT = "%s?version=%s&appkey=%s&userId=%s&logId=%s&deviceId=%s&deviceInfo=%s&platform=Android";
    private static final String NO_DATA_LOG_CONTENT = "no data";
    private static final String MODULE_NOT_INIT_CONTENT = "no log module ";
    private String version;
    private String deviceId;
    private String appKey;
    private String uploadUrl;
    private String userId;
    private String logId;
    private long startTime;
    private long endTime;
    private String logCacheDir;

    public FullUploadLogTask(String version, String deviceId, String appKey, String url, String userId, String logId, long startTime, long endTime, String logCacheDir) {
        this.version = version;
        this.deviceId = deviceId;
        this.appKey = appKey;
        this.uploadUrl = url;
        this.userId = userId;
        this.logId = logId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.logCacheDir = logCacheDir;
    }

    public boolean execute() {
        String outputLogCachePath = this.getLogFile();
        if (outputLogCachePath == null) {
            return false;
        }
        return this.upload(outputLogCachePath);
    }

    @Override
    protected String getUploadUrl() {
        return String.format(FULL_UPLOAD_URL_FORMAT, this.uploadUrl, this.encodeParams(this.version), this.encodeParams(this.appKey), this.encodeParams(this.userId), this.encodeParams(this.logId), this.encodeParams(this.deviceId), this.encodeParams(DeviceUtils.getDeviceBandModelVersion()));
    }

    @Override
    protected void onUploadResponse(String response) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLogFile() {
        boolean mkLogDirResult;
        final CountDownLatch logReadLatch = new CountDownLatch(1);
        if (this.logCacheDir == null) {
            return null;
        }
        File logFile = new File(this.logCacheDir, "f_" + System.currentTimeMillis() + "_log_cache");
        if (!logFile.getParentFile().exists() && !(mkLogDirResult = logFile.getParentFile().mkdirs())) {
            RLog.d(TAG, "getLogFile mkdirs return false");
        }
        final AtomicLong fileWriteLength = new AtomicLong(0L);
        FileOutputStream logFileInput = null;
        try {
            final FileOutputStream logFileInputRef = logFileInput = new FileOutputStream(logFile);
            RtLogNativeProxy.setQueryFullLogListener(new RtFullListener(){

                @Override
                public void NotifyFull() {
                    ByteBuffer logReadBuffer = this.getByteBuffer();
                    logReadBuffer.flip();
                    int remaining = logReadBuffer.remaining();
                    byte[] buffer = new byte[remaining];
                    logReadBuffer.get(buffer);
                    logReadBuffer.clear();
                    String log = new String(buffer).trim() + "\r\n";
                    try {
                        logFileInputRef.write(log.getBytes());
                    }
                    catch (IOException e) {
                        RLog.e(TAG, "getLogFile write log error", e);
                    }
                    logReadBuffer.clear();
                    fileWriteLength.getAndAdd(log.length());
                }

                @Override
                public void NotifyFullEnd(int result) {
                    RLog.d(TAG, "getLogFile NotifyFullEnd result:" + result);
                    if (fileWriteLength.get() == 0L) {
                        try {
                            logFileInputRef.write(FullUploadLogTask.NO_DATA_LOG_CONTENT.getBytes());
                        }
                        catch (IOException e) {
                            RLog.e(TAG, "getLogFile write no data error", e);
                        }
                    }
                    logReadLatch.countDown();
                }
            });
            RtLogNativeProxy.queryFullLog(4, this.startTime, this.endTime);
            logReadLatch.await();
            logFileInput.flush();
            String string2 = logFile.getAbsolutePath();
            return string2;
        }
        catch (InterruptedException e) {
            RLog.e(TAG, "getLogFile", e);
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            RLog.e(TAG, "getLogFile", e);
        }
        finally {
            if (logFileInput != null) {
                try {
                    logFileInput.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    public String getLogId() {
        return this.logId;
    }

    public boolean equals(Object obj) {
        FullUploadLogTask targetTask;
        if (obj instanceof FullUploadLogTask && (targetTask = (FullUploadLogTask)obj).getLogId() != null && targetTask.getLogId().equals(this.getLogId())) {
            return true;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

