/*
 * Decompiled with CFR 0.152.
 */
package io.rong.push.rongpush;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.rong.imlib.common.DeviceUtils;
import io.rong.imlib.common.SharedPreferencesUtils;
import java.util.ArrayList;
import java.util.List;

public class RongPushCacheHelper {
    private static final String PUSH_SHARE_PREFERENCE = "RongPush";
    public static final String DeviceId = "deviceId";
    private final String TIME = "navigation_time";
    private final String ADDRESS_LIST = "addressList";
    private final long EXPIRED_TIME = 0x6DDD00L;

    public static RongPushCacheHelper getInstance() {
        return Singleton.sInstance;
    }

    public boolean isCacheValid(Context context, String appKey) {
        SharedPreferences sp = SharedPreferencesUtils.get(context, PUSH_SHARE_PREFERENCE, 0);
        String cachedIP = sp.getString("addressList", "");
        long cachedTime = sp.getLong("navigation_time", -1L);
        long currentTime = System.currentTimeMillis();
        return currentTime - cachedTime < 0x6DDD00L && !TextUtils.isEmpty((CharSequence)cachedIP) && this.getCachedDeviceId(context).equals(DeviceUtils.getDeviceId(context, appKey));
    }

    public void cacheRongPushIPs(Context context, ArrayList<String> addressList, long time) {
        SharedPreferences preferences = SharedPreferencesUtils.get(context, PUSH_SHARE_PREFERENCE, 0);
        SharedPreferences.Editor editor = preferences.edit();
        Gson gson = new Gson();
        String jsonString = gson.toJson(addressList);
        editor.putString("addressList", jsonString);
        editor.putLong("navigation_time", time);
        editor.commit();
    }

    public ArrayList<String> getCachedAddressList(Context context) {
        SharedPreferences preferences = SharedPreferencesUtils.get(context, PUSH_SHARE_PREFERENCE, 0);
        ArrayList dataList = new ArrayList();
        String strJson = preferences.getString("addressList", "");
        if (TextUtils.isEmpty((CharSequence)strJson)) {
            return dataList;
        }
        Gson gson = new Gson();
        dataList = (ArrayList)gson.fromJson(strJson, new TypeToken<List<String>>(){}.getType());
        return dataList;
    }

    private String getCachedDeviceId(Context context) {
        SharedPreferences preferences = SharedPreferencesUtils.get(context, PUSH_SHARE_PREFERENCE, 0);
        return preferences.getString(DeviceId, "");
    }

    private static class Singleton {
        static RongPushCacheHelper sInstance = new RongPushCacheHelper();

        private Singleton() {
        }
    }
}

