/*
 * Decompiled with CFR 0.152.
 */
package io.rong.push.rongpush;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import io.rong.imlib.RongJobIntentService;
import io.rong.imlib.common.SharedPreferencesUtils;
import io.rong.push.common.RLog;
import io.rong.push.rongpush.PushConnectivityManager;
import io.rong.push.rongpush.PushReceiver;

public class PushService
extends RongJobIntentService {
    private static final String TAG = PushService.class.getSimpleName();
    private static final int UNIQUE_JOB_ID = 2017113004;
    private PushReceiver pushReceiver;
    private static volatile boolean pushCanceled = false;

    @Override
    public void onCreate() {
        super.onCreate();
        try {
            this.pushReceiver = new PushReceiver();
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            this.registerReceiver(this.pushReceiver, filter);
        }
        catch (Exception e) {
            RLog.d(TAG, "Failed to register push receiver.");
        }
        RLog.d(TAG, "OnCreate");
    }

    @Override
    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        RLog.d(TAG, "onStartCommand, intent " + intent);
        return this.handleWork(intent);
    }

    @Override
    protected void onHandleWork(@NonNull Intent intent) {
        this.handleWork(intent);
    }

    @Override
    public void onDestroy() {
        RLog.d(TAG, "onDestroy");
        super.onDestroy();
        try {
            this.unregisterReceiver(this.pushReceiver);
        }
        catch (Exception e) {
            RLog.d(TAG, "Failed to unregister push receiver.");
        }
    }

    public static void enqueueWork(Context context, Intent intent) {
        PushService.enqueueWork(context, PushService.class, 2017113004, intent);
    }

    private void initWithCachedParams() {
        SharedPreferences sp = SharedPreferencesUtils.get((Context)this, "RongPush", 0);
        String appKey = sp.getString("appKey", "");
        String deviceId = sp.getString("deviceId", "");
        String pushDomain = sp.getString("pushDomain", "");
        if (!(TextUtils.isEmpty((CharSequence)appKey) || TextUtils.isEmpty((CharSequence)deviceId) || PushConnectivityManager.getInstance().isInitialized())) {
            PushConnectivityManager.getInstance().init((Context)this, deviceId, appKey);
            if (!TextUtils.isEmpty((CharSequence)pushDomain)) {
                PushConnectivityManager.getInstance().setServerDomain(pushDomain);
            }
        }
    }

    private void initAndUpdateWithIntentParams(Intent intent) {
        String appKey = intent.getStringExtra("appKey");
        String deviceId = intent.getStringExtra("deviceId");
        String pushDomain = intent.getStringExtra("pushDomain");
        SharedPreferences sp = SharedPreferencesUtils.get((Context)this, "RongPush", 0);
        String cachedAppKey = sp.getString("appKey", "");
        String cachedDeviceId = sp.getString("deviceId", "");
        String cachedPushDomain = sp.getString("pushDomain", "");
        PushConnectivityManager.getInstance().init((Context)this, deviceId, appKey);
        PushConnectivityManager.getInstance().setServerDomain(pushDomain);
        SharedPreferences.Editor editor = sp.edit();
        if (!cachedPushDomain.equals(pushDomain)) {
            editor.putString("pushDomain", pushDomain);
        }
        if (!cachedAppKey.equals(appKey) || !cachedDeviceId.equals(deviceId)) {
            editor.putString("appKey", appKey);
            editor.putString("deviceId", deviceId);
            RLog.d(TAG, "update cached values.");
        }
        editor.commit();
    }

    private int handleWork(Intent intent) {
        SharedPreferences sp = SharedPreferencesUtils.get((Context)this, "RongPush", 0);
        SharedPreferences.Editor editor = sp.edit();
        if (intent == null || intent.getAction() == null) {
            RLog.d(TAG, "intent is null.");
            if (!PushConnectivityManager.getInstance().isInitialized()) {
                this.initWithCachedParams();
            }
            PushConnectivityManager.getInstance().connect();
            return 1;
        }
        if (intent.getAction().equals("io.rong.push.intent.action.INIT")) {
            if (!PushConnectivityManager.getInstance().isInitialized()) {
                this.initAndUpdateWithIntentParams(intent);
            }
            PushConnectivityManager.getInstance().connect();
        } else {
            if (!PushConnectivityManager.getInstance().isInitialized()) {
                this.initWithCachedParams();
            }
            switch (intent.getAction()) {
                case "io.rong.push.intent.action.REGISTRATION_INFO": {
                    String pushTypeUsed = sp.getString("pushTypeUsed", "");
                    String info = intent.getStringExtra("regInfo");
                    if (!TextUtils.isEmpty((CharSequence)info)) {
                        String[] infos = info.split("\\|");
                        RLog.i(TAG, "received info:" + info + ",pushType cached:" + pushTypeUsed);
                        if (infos[0].equals(pushTypeUsed)) {
                            PushConnectivityManager.getInstance().sendRegistrationIDToServer(info);
                            break;
                        }
                        RLog.e(TAG, "Push type received is different from the one cached. So ignore this event.");
                        break;
                    }
                    RLog.e(TAG, "regInfo value error. So ignore this event.");
                    break;
                }
                case "io.rong.push.intent.action.REDIRECT": {
                    editor.remove("navigation_ip_value");
                    editor.remove("navigation_time");
                    editor.commit();
                    PushConnectivityManager.getInstance().disconnect();
                    PushConnectivityManager.getInstance().connect();
                    break;
                }
                case "io.rong.push.intent.action.HEART_BEAT": {
                    if (pushCanceled) {
                        return 1;
                    }
                    String extra = intent.getStringExtra("PING");
                    if (extra == null) {
                        PushConnectivityManager.getInstance().ping();
                        break;
                    }
                    if (!extra.equals("PING")) break;
                    PushConnectivityManager.getInstance().onPingTimeout();
                    break;
                }
                case "io.rong.push.intent.action.CUSTOM_HEART_BEAT": {
                    String customExtra = intent.getStringExtra("PING");
                    if (customExtra == null) {
                        PushConnectivityManager.getInstance().customPing();
                        break;
                    }
                    if (!customExtra.equals("PING")) break;
                    PushConnectivityManager.getInstance().onPingTimeout();
                    break;
                }
                case "io.rong.push.intent.action.STOP_PUSH": {
                    PushConnectivityManager.getInstance().disconnect();
                    this.stopSelf();
                    break;
                }
                case "io.rong.push.intent.action.UNINIT": {
                    editor.clear().commit();
                    PushConnectivityManager.getInstance().uninit();
                    this.stopSelf();
                    break;
                }
                case "io.rong.push.intent.action.CANCEL_HEART_BEAT": {
                    pushCanceled = true;
                    PushConnectivityManager.getInstance().cancelHeartbeat();
                    break;
                }
                case "android.net.conn.CONNECTIVITY_CHANGE": {
                    PushConnectivityManager.NetworkType last = PushConnectivityManager.getInstance().getNetworkType();
                    NetworkInfo.State wifi_state = null;
                    NetworkInfo.State mobile_state = null;
                    ConnectivityManager ConnManager = (ConnectivityManager)this.getSystemService("connectivity");
                    if (ConnManager != null) {
                        NetworkInfo mobileNetworkInfo;
                        NetworkInfo wifiNetworkInfo = ConnManager.getNetworkInfo(1);
                        if (wifiNetworkInfo != null) {
                            wifi_state = wifiNetworkInfo.getState();
                        }
                        if ((mobileNetworkInfo = ConnManager.getNetworkInfo(0)) != null) {
                            mobile_state = mobileNetworkInfo.getState();
                        }
                        if (wifi_state == NetworkInfo.State.CONNECTED) {
                            PushConnectivityManager.getInstance().setNetworkType(PushConnectivityManager.NetworkType.WIFI);
                        } else if (mobile_state == NetworkInfo.State.CONNECTED) {
                            PushConnectivityManager.getInstance().setNetworkType(PushConnectivityManager.NetworkType.MOBILE);
                        } else {
                            PushConnectivityManager.getInstance().setNetworkType(PushConnectivityManager.NetworkType.ERROR);
                        }
                    }
                    PushConnectivityManager.NetworkType current = PushConnectivityManager.getInstance().getNetworkType();
                    RLog.d(TAG, "wifi = " + wifi_state + ", mobile = " + mobile_state + ", last = " + (Object)((Object)last) + ", current = " + (Object)((Object)current));
                    if (current.equals((Object)PushConnectivityManager.NetworkType.ERROR)) {
                        PushConnectivityManager.getInstance().disconnect();
                        break;
                    }
                    if (last.equals((Object)PushConnectivityManager.NetworkType.ERROR) || last.equals((Object)PushConnectivityManager.NetworkType.NONE)) {
                        PushConnectivityManager.getInstance().connect();
                        break;
                    }
                    PushConnectivityManager.getInstance().disconnect();
                    PushConnectivityManager.getInstance().connect();
                    break;
                }
                case "android.intent.action.USER_PRESENT": 
                case "android.intent.action.ACTION_POWER_CONNECTED": 
                case "android.intent.action.ACTION_POWER_DISCONNECTED": 
                case "android.intent.action.BOOT_COMPLETED": {
                    PushConnectivityManager.getInstance().connect();
                }
            }
        }
        return 1;
    }
}

