/*
 * Decompiled with CFR 0.152.
 */
package io.rong.push.rongpush;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.HandlerThread;
import android.os.Message;
import android.os.Parcelable;
import android.os.SystemClock;
import android.text.TextUtils;
import io.rong.common.rlog.RLog;
import io.rong.imlib.common.DeviceUtils;
import io.rong.push.PushErrorCode;
import io.rong.push.PushType;
import io.rong.push.common.stateMachine.State;
import io.rong.push.common.stateMachine.StateMachine;
import io.rong.push.core.PushClient;
import io.rong.push.core.PushConnectHandler;
import io.rong.push.core.PushNaviClient;
import io.rong.push.core.PushProtocalStack;
import io.rong.push.core.PushUtils;
import io.rong.push.notification.PushNotificationMessage;
import io.rong.push.pushconfig.IResultCallback;
import io.rong.push.pushconfig.PushNaviObserver;
import io.rong.push.rongpush.PushReceiver;
import java.util.ArrayList;

public class PushConnectivityManager
extends StateMachine {
    private static final String TAG = "PushConnectivityManager";
    private Context mContext;
    private PushClient pushClient;
    private String appKey;
    private static final int EVENT_CONNECT_TO_NAVI = 1;
    private static final int EVENT_NAVI_CONNECTED = 2;
    private static final int EVENT_CONNECT_TO_SERVER = 2;
    private static final int EVENT_CONNECTED = 3;
    private static final int EVENT_DISCONNECT = 4;
    private static final int EVENT_DISCONNECTED = 5;
    private static final int EVENT_HEART_BEAT = 6;
    private static final int EVENT_PING_FAILURE = 7;
    private static final int EVENT_PING_SUCCESS = 8;
    private static final int EVENT_USER_OPERATION = 9;
    private static final int EVENT_SEND_REGISTRATION_INFO = 10;
    private static final int EVENT_CUSTOM_HEART_BEAT = 11;
    private NetworkType networkType = NetworkType.NONE;
    private boolean initialized = false;
    private int ALARM_REQUEST_CODE = 101;
    private int ALARM_PING_REQUEST_CODE = 102;
    private PushNaviClient pushNaviClient;
    private ArrayList<String> serverIpList;
    private PushConnectHandler connectHandler;
    private DisconnectedState disconnectedState = new DisconnectedState();
    private NaviConnectingState naviConnectingState = new NaviConnectingState();
    private ConnectingState connectingState = new ConnectingState();
    private CustomPingState customPingState = new CustomPingState();
    private PingState pingState = new PingState();
    private ConnectedState connectedState = new ConnectedState();

    public static PushConnectivityManager getInstance() {
        return Singleton.sInstance;
    }

    protected PushConnectivityManager() {
        super(TAG);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void init(final Context context, String deviceId, String appKey) {
        io.rong.push.common.RLog.d(TAG, "init, initialized = " + this.initialized + ", deviceId = " + deviceId + ", appKey = " + appKey);
        this.mContext = context;
        this.initialized = true;
        this.appKey = appKey;
        this.pushNaviClient = new PushNaviClient();
        HandlerThread thread = new HandlerThread("connect");
        thread.start();
        this.connectHandler = new PushConnectHandler(thread.getLooper());
        this.pushClient = new PushClient(context, appKey, DeviceUtils.getPhoneInformation(context), new PushClient.ClientListener(){

            @Override
            public void onMessageArrived(PushProtocalStack.PublishMessage msg) {
                if (msg == null || TextUtils.isEmpty((CharSequence)msg.getDataAsString())) {
                    io.rong.push.common.RLog.e(PushConnectivityManager.TAG, "sendNotification, msg = null");
                    return;
                }
                io.rong.push.common.RLog.i(PushConnectivityManager.TAG, msg.getDataAsString());
                PushNotificationMessage pushNotificationMessage = PushUtils.transformToPushMessage(msg.getDataAsString());
                String packageName = PushUtils.getPackageName(msg.getDataAsString());
                if (TextUtils.isEmpty((CharSequence)packageName)) {
                    io.rong.push.common.RLog.e(PushConnectivityManager.TAG, "package name can't empty!");
                    return;
                }
                Intent intent = new Intent();
                intent.setAction("io.rong.push.intent.MESSAGE_ARRIVED");
                intent.setPackage(packageName);
                intent.putExtra("pushType", PushType.RONG.getName());
                intent.putExtra("message", (Parcelable)pushNotificationMessage);
                if (Build.VERSION.SDK_INT >= 12) {
                    intent.setFlags(32);
                }
                context.sendBroadcast(intent);
            }

            @Override
            public void onPingSuccess() {
                io.rong.push.common.RLog.d(PushConnectivityManager.TAG, "onPingSuccess");
                PushConnectivityManager.this.getHandler().sendEmptyMessage(8);
            }

            @Override
            public void onDisConnected() {
                io.rong.push.common.RLog.d(PushConnectivityManager.TAG, "onDisConnected");
                PushConnectivityManager.this.getHandler().sendEmptyMessage(5);
            }

            @Override
            public void onPingFailure() {
                io.rong.push.common.RLog.d(PushConnectivityManager.TAG, "onPingFailure");
                PushConnectivityManager.this.getHandler().sendEmptyMessage(7);
            }
        });
        this.addState(this.disconnectedState);
        this.addState(this.naviConnectingState, this.disconnectedState);
        this.addState(this.connectingState, this.disconnectedState);
        this.addState(this.connectedState, this.disconnectedState);
        this.addState(this.pingState, this.disconnectedState);
        this.addState(this.customPingState, this.disconnectedState);
        this.setInitialState(this.disconnectedState);
        this.start();
    }

    public void setServerDomain(String domain) {
        io.rong.push.common.RLog.i(TAG, "setServerDomain " + domain);
        if (TextUtils.isEmpty((CharSequence)domain)) {
            io.rong.push.common.RLog.e(TAG, "server address can't be empty!!");
            return;
        }
        if (this.pushNaviClient == null) {
            io.rong.push.common.RLog.e(TAG, "should init first!");
            return;
        }
        this.pushNaviClient.setPushNaviUrl(domain);
    }

    public void connect() {
        if (!this.isInitialized()) {
            io.rong.push.common.RLog.e(TAG, "connect does not init.");
            return;
        }
        this.getHandler().sendEmptyMessage(1);
    }

    public void ping() {
        if (!this.isInitialized()) {
            io.rong.push.common.RLog.e(TAG, "ping: does not init.");
            return;
        }
        this.getHandler().sendEmptyMessage(6);
    }

    public void customPing() {
        if (!this.isInitialized()) {
            io.rong.push.common.RLog.e(TAG, "customPing: does not init.");
            return;
        }
        this.getHandler().sendEmptyMessage(11);
    }

    public void onPingTimeout() {
        if (!this.isInitialized()) {
            io.rong.push.common.RLog.e(TAG, "onPingTimeout: does not init.");
            return;
        }
        this.getHandler().sendEmptyMessage(7);
    }

    public void sendRegistrationIDToServer(String regInfo) {
        if (!this.isInitialized()) {
            io.rong.push.common.RLog.e(TAG, "sendRegistrationIDToServer: does not init.");
            return;
        }
        Message msg = new Message();
        msg.what = 10;
        msg.obj = regInfo;
        this.getHandler().sendMessage(msg);
    }

    public void disconnect() {
        if (!this.isInitialized()) {
            io.rong.push.common.RLog.e(TAG, "disconnect does not init.");
            return;
        }
        this.cancelHeartbeat();
        this.getHandler().sendEmptyMessage(4);
    }

    public void setNetworkType(NetworkType networkType) {
        this.networkType = networkType;
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    private void connectToNavi() {
        this.pushNaviClient.getPushServerIPs(this.mContext, this.appKey, true, new PushNaviObserver(){

            @Override
            public void onSuccess(ArrayList<String> addressList) {
                PushConnectivityManager.this.serverIpList = addressList;
                PushConnectivityManager.this.getHandler().sendEmptyMessage(2);
            }

            @Override
            public void onError(PushErrorCode errorCode) {
                io.rong.push.common.RLog.e(PushConnectivityManager.TAG, "get navi onError.");
                PushConnectivityManager.this.getHandler().sendEmptyMessage(5);
            }
        });
    }

    private void connectToServer() {
        if (!this.isInitialized()) {
            io.rong.push.common.RLog.e(TAG, "connect does not init.");
            return;
        }
        if (this.serverIpList == null || this.serverIpList.size() <= 0) {
            io.rong.push.common.RLog.e(TAG, "server ip can't be null.");
            this.getHandler().sendEmptyMessage(5);
            return;
        }
        this.connectHandler.connect(this.mContext, this.pushClient, this.serverIpList, this.appKey, new IResultCallback<String>(){

            @Override
            public void onSuccess(String s) {
                PushConnectivityManager.this.getHandler().sendEmptyMessage(3);
            }

            @Override
            public void onError(PushErrorCode code) {
                PushConnectivityManager.this.getHandler().sendEmptyMessage(5);
            }
        });
    }

    public void startPingTimer() {
        io.rong.push.common.RLog.i(TAG, "startPingTimer, 10s");
        if (!this.isInitialized()) {
            io.rong.push.common.RLog.e(TAG, "startPingTimer. does not init.");
            return;
        }
        long nextMillis = SystemClock.elapsedRealtime() + 10000L;
        this.startPushTimer("PING", "PING", this.ALARM_PING_REQUEST_CODE, nextMillis);
    }

    public void stopPingTimer() {
        io.rong.push.common.RLog.i(TAG, "stopPingTimer");
        if (!this.isInitialized()) {
            io.rong.push.common.RLog.e(TAG, "stopPingTimer. does not init.");
            return;
        }
        this.stopPushTimer("PING", "PING", this.ALARM_PING_REQUEST_CODE);
    }

    @TargetApi(value=23)
    public void setNextHeartbeat() {
        long nextMillis;
        io.rong.push.common.RLog.i(TAG, "startHeartbeat");
        if (!this.isInitialized()) {
            io.rong.push.common.RLog.e(TAG, "setNextHeartbeat. does not init.");
            return;
        }
        try {
            String heartbeat_timer = this.mContext.getResources().getString(this.mContext.getResources().getIdentifier("push_heartbeat_timer", "string", this.mContext.getPackageName()));
            nextMillis = SystemClock.elapsedRealtime() + Long.parseLong(heartbeat_timer);
        }
        catch (Exception e) {
            io.rong.push.common.RLog.d(TAG, "use default heartbeat timer.");
            nextMillis = SystemClock.elapsedRealtime() + 240000L;
        }
        this.startPushTimer(null, null, this.ALARM_REQUEST_CODE, nextMillis);
    }

    private void startPushTimer(String pushExtraName, String pushExtraValue, int requestCode, long nextMillis) {
        Intent intent = new Intent(this.mContext, PushReceiver.class);
        intent.setAction("io.rong.push.intent.action.HEART_BEAT");
        if (!TextUtils.isEmpty((CharSequence)pushExtraName) && !TextUtils.isEmpty((CharSequence)pushExtraValue)) {
            intent.putExtra(pushExtraName, pushExtraValue);
        }
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)requestCode, (Intent)intent, (int)0x8000000);
        AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        if (alarmManager == null || pendingIntent == null) {
            RLog.e(TAG, "alarmManager or pendingIntent is null");
            return;
        }
        alarmManager.cancel(pendingIntent);
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                alarmManager.setExactAndAllowWhileIdle(2, nextMillis, pendingIntent);
            }
            catch (Exception e) {
                io.rong.push.common.RLog.e(TAG, e.getMessage());
            }
            catch (NoSuchMethodError error) {
                io.rong.push.common.RLog.e(TAG, error.getMessage());
                alarmManager.setExact(2, nextMillis, pendingIntent);
            }
        } else if (Build.VERSION.SDK_INT >= 19) {
            try {
                alarmManager.setExact(2, nextMillis, pendingIntent);
            }
            catch (Exception e) {
                io.rong.push.common.RLog.e(TAG, e.getMessage());
            }
            catch (NoSuchMethodError error) {
                io.rong.push.common.RLog.e(TAG, error.getMessage());
                alarmManager.set(2, nextMillis, pendingIntent);
            }
        } else {
            alarmManager.set(2, nextMillis, pendingIntent);
        }
    }

    private void stopPushTimer(String pushExtraName, String pushExtraValue, int requestCode) {
        Intent intent = new Intent(this.mContext, PushReceiver.class);
        intent.setAction("io.rong.push.intent.action.HEART_BEAT");
        if (!TextUtils.isEmpty((CharSequence)pushExtraName) && !TextUtils.isEmpty((CharSequence)pushExtraValue)) {
            intent.putExtra(pushExtraName, pushExtraValue);
        }
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)requestCode, (Intent)intent, (int)0x8000000);
        AlarmManager mAlarmMng = (AlarmManager)this.mContext.getSystemService("alarm");
        if (pendingIntent != null && mAlarmMng != null) {
            mAlarmMng.cancel(pendingIntent);
        }
    }

    public void cancelHeartbeat() {
        io.rong.push.common.RLog.i(TAG, "cancelHeartbeat");
        if (!this.isInitialized()) {
            io.rong.push.common.RLog.e(TAG, "cancelHeartbeat. does not init.");
            return;
        }
        this.stopPushTimer(null, null, this.ALARM_REQUEST_CODE);
        this.stopPingTimer();
    }

    public void uninit() {
        if (this.pushClient != null) {
            this.pushClient.uninit();
        }
        this.cancelHeartbeat();
        this.initialized = false;
    }

    private class ConnectedState
    extends State {
        private ConnectedState() {
        }

        @Override
        public void enter() {
            io.rong.push.common.RLog.d(PushConnectivityManager.TAG, "enter " + this.getClass().getSimpleName());
        }

        @Override
        public boolean processMessage(Message msg) {
            io.rong.push.common.RLog.d(PushConnectivityManager.TAG, this.getClass().getSimpleName() + ": process msg = " + msg.what);
            switch (msg.what) {
                case 4: {
                    PushConnectivityManager.this.pushClient.disconnect();
                    break;
                }
                case 6: {
                    PushConnectivityManager.this.pushClient.ping();
                    PushConnectivityManager.this.transitionTo(PushConnectivityManager.this.pingState);
                    break;
                }
                case 11: {
                    PushConnectivityManager.this.pushClient.ping();
                    PushConnectivityManager.this.transitionTo(PushConnectivityManager.this.customPingState);
                    break;
                }
                case 7: {
                    PushConnectivityManager.this.stopPingTimer();
                    PushConnectivityManager.this.pushClient.reset();
                    PushConnectivityManager.this.transitionTo(PushConnectivityManager.this.disconnectedState);
                    PushConnectivityManager.this.getHandler().sendEmptyMessage(2);
                    break;
                }
                case 5: {
                    PushConnectivityManager.this.pushClient.reset();
                    PushConnectivityManager.this.transitionTo(PushConnectivityManager.this.disconnectedState);
                }
            }
            return true;
        }
    }

    private class PingState
    extends State {
        private PingState() {
        }

        @Override
        public void enter() {
            io.rong.push.common.RLog.d(PushConnectivityManager.TAG, "enter " + this.getClass().getSimpleName());
            PushConnectivityManager.this.startPingTimer();
        }

        @Override
        public boolean processMessage(Message msg) {
            io.rong.push.common.RLog.d(PushConnectivityManager.TAG, this.getClass().getSimpleName() + ": process msg = " + msg.what);
            switch (msg.what) {
                case 3: 
                case 8: {
                    PushConnectivityManager.this.stopPingTimer();
                    PushConnectivityManager.this.setNextHeartbeat();
                    PushConnectivityManager.this.transitionTo(PushConnectivityManager.this.connectedState);
                    break;
                }
                case 6: 
                case 11: {
                    PushConnectivityManager.this.pushClient.reset();
                    PushConnectivityManager.this.transitionTo(PushConnectivityManager.this.disconnectedState);
                    PushConnectivityManager.this.getHandler().sendEmptyMessage(2);
                    break;
                }
                case 7: {
                    PushConnectivityManager.this.stopPingTimer();
                    PushConnectivityManager.this.pushClient.reset();
                    PushConnectivityManager.this.getHandler().sendEmptyMessage(2);
                    PushConnectivityManager.this.transitionTo(PushConnectivityManager.this.disconnectedState);
                    break;
                }
                case 2: {
                    PushConnectivityManager.this.connectToServer();
                    PushConnectivityManager.this.transitionTo(PushConnectivityManager.this.connectingState);
                    break;
                }
                case 4: {
                    PushConnectivityManager.this.pushClient.disconnect();
                    PushConnectivityManager.this.transitionTo(PushConnectivityManager.this.disconnectedState);
                    break;
                }
                case 5: {
                    PushConnectivityManager.this.pushClient.reset();
                    PushConnectivityManager.this.transitionTo(PushConnectivityManager.this.disconnectedState);
                }
                case 10: {
                    PushConnectivityManager.this.deferMessage(msg);
                }
            }
            return true;
        }
    }

    private class CustomPingState
    extends PingState {
        private CustomPingState() {
        }

        @Override
        public boolean processMessage(Message msg) {
            io.rong.push.common.RLog.d(PushConnectivityManager.TAG, this.getClass().getSimpleName() + ": process msg = " + msg.what);
            switch (msg.what) {
                case 3: 
                case 8: {
                    PushConnectivityManager.this.stopPingTimer();
                    PushConnectivityManager.this.transitionTo(PushConnectivityManager.this.connectedState);
                }
            }
            return true;
        }
    }

    private class ConnectingState
    extends State {
        private ConnectingState() {
        }

        @Override
        public void enter() {
            io.rong.push.common.RLog.d(PushConnectivityManager.TAG, "enter " + this.getClass().getSimpleName());
        }

        @Override
        public boolean processMessage(Message msg) {
            io.rong.push.common.RLog.d(PushConnectivityManager.TAG, this.getClass().getSimpleName() + ": process msg = " + msg.what);
            switch (msg.what) {
                case 3: {
                    PushConnectivityManager.this.setNextHeartbeat();
                    PushConnectivityManager.this.transitionTo(PushConnectivityManager.this.connectedState);
                    break;
                }
                case 2: 
                case 10: {
                    PushConnectivityManager.this.deferMessage(msg);
                    break;
                }
                case 4: 
                case 5: {
                    PushConnectivityManager.this.pushClient.reset();
                    PushConnectivityManager.this.transitionTo(PushConnectivityManager.this.disconnectedState);
                    break;
                }
                case 8: {
                    PushConnectivityManager.this.stopPingTimer();
                }
            }
            return true;
        }
    }

    private class NaviConnectingState
    extends State {
        private NaviConnectingState() {
        }

        @Override
        public void enter() {
            io.rong.push.common.RLog.d(PushConnectivityManager.TAG, "enter " + this.getClass().getSimpleName());
        }

        @Override
        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    PushConnectivityManager.this.connectToServer();
                    PushConnectivityManager.this.transitionTo(PushConnectivityManager.this.connectingState);
                    break;
                }
                case 5: {
                    PushConnectivityManager.this.pushClient.reset();
                    PushConnectivityManager.this.transitionTo(PushConnectivityManager.this.disconnectedState);
                }
            }
            return true;
        }
    }

    private class DisconnectedState
    extends State {
        private DisconnectedState() {
        }

        @Override
        public void enter() {
            io.rong.push.common.RLog.d(PushConnectivityManager.TAG, "enter " + this.getClass().getSimpleName());
        }

        @Override
        public boolean processMessage(Message msg) {
            io.rong.push.common.RLog.d(PushConnectivityManager.TAG, this.getClass().getSimpleName() + ": process msg = " + msg.what);
            switch (msg.what) {
                case 10: {
                    PushConnectivityManager.this.deferMessage(msg);
                    break;
                }
                case 1: 
                case 2: 
                case 6: 
                case 9: 
                case 11: {
                    PushConnectivityManager.this.connectToNavi();
                    PushConnectivityManager.this.transitionTo(PushConnectivityManager.this.naviConnectingState);
                    break;
                }
                case 8: {
                    PushConnectivityManager.this.stopPingTimer();
                    break;
                }
                case 5: {
                    PushConnectivityManager.this.pushClient.reset();
                }
            }
            return true;
        }
    }

    private static class Singleton {
        static PushConnectivityManager sInstance = new PushConnectivityManager();

        private Singleton() {
        }
    }

    public static enum NetworkType {
        NONE,
        WIFI,
        MOBILE,
        ERROR;

    }
}

