/*
 * Decompiled with CFR 0.152.
 */
package io.rong.push.pushconfig;

import io.rong.push.PushType;
import io.rong.push.common.RLog;
import io.rong.push.platform.IPush;
import io.rong.push.platform.google.FCMPush;
import io.rong.push.platform.google.GCMPush;
import io.rong.push.platform.hms.HWPush;
import io.rong.push.platform.meizu.MeizuPush;
import io.rong.push.platform.mi.MiPush;
import io.rong.push.platform.oppo.OppoPush;
import io.rong.push.platform.vivo.VivoPush;
import io.rong.push.rongpush.RongPush;
import java.util.concurrent.ConcurrentHashMap;

public class PushFactory {
    private static final String TAG = PushFactory.class.getSimpleName();
    private static ConcurrentHashMap<PushType, IPush> pushProcessorMap = new ConcurrentHashMap();

    public static IPush getPushProcessorByType(PushType pushType) {
        IPush iPush = pushProcessorMap.get((Object)pushType);
        if (iPush != null) {
            return iPush;
        }
        if (pushType.equals((Object)PushType.GOOGLE_GCM)) {
            iPush = new GCMPush();
        } else if (pushType.equals((Object)PushType.GOOGLE_FCM)) {
            iPush = new FCMPush();
        } else if (pushType.equals((Object)PushType.HUAWEI)) {
            iPush = new HWPush();
        } else if (pushType.equals((Object)PushType.XIAOMI)) {
            iPush = new MiPush();
        } else if (pushType.equals((Object)PushType.MEIZU)) {
            iPush = new MeizuPush();
        } else if (pushType.equals((Object)PushType.RONG)) {
            iPush = new RongPush();
        } else if (pushType.equals((Object)PushType.VIVO)) {
            iPush = new VivoPush();
        } else if (pushType.equals((Object)PushType.OPPO)) {
            iPush = new OppoPush();
        } else {
            RLog.e(TAG, "unsupported push type!!");
            return null;
        }
        pushProcessorMap.put(pushType, iPush);
        return iPush;
    }

    public static void setPushProcessor(PushType pushType, IPush processor) {
        pushProcessorMap.put(pushType, processor);
    }
}

