/*
 * Decompiled with CFR 0.152.
 */
package io.rong.push.platform.vivo;

import android.content.Context;
import com.vivo.push.model.UPSNotificationMessage;
import com.vivo.push.sdk.OpenClientPushMessageReceiver;
import io.rong.push.PushManager;
import io.rong.push.PushType;
import io.rong.push.RongPushClient;
import io.rong.push.common.RLog;
import io.rong.push.notification.PushNotificationMessage;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class VivoPushMessageReceiver
extends OpenClientPushMessageReceiver {
    private static final String TAG = VivoPushMessageReceiver.class.getSimpleName();

    public void onNotificationMessageClicked(Context context, UPSNotificationMessage message) {
        RLog.v(TAG, "onNotificationMessageClicked is called. " + message.getContent() + ", " + message.getParams());
        PushNotificationMessage pushNotificationMessage = this.transformVivoToPushMessage(message.getTitle(), message.getContent(), message.getParams());
        if (pushNotificationMessage != null) {
            PushManager.getInstance().onNotificationMessageClicked(context, PushType.VIVO, pushNotificationMessage);
        }
    }

    public void onReceiveRegId(Context context, String token) {
        RLog.d(TAG, "Vivo onReceiveRegId:" + token);
        PushManager.getInstance().onReceiveToken(context, PushType.VIVO, token);
    }

    private PushNotificationMessage transformVivoToPushMessage(String title, String content, Map<String, String> params) {
        if (params == null) {
            return null;
        }
        PushNotificationMessage pushNotificationMessage = null;
        String rc = params.get("rc");
        if (rc != null) {
            try {
                JSONObject rcJson = new JSONObject(rc);
                pushNotificationMessage = new PushNotificationMessage();
                pushNotificationMessage.setPushTitle(title);
                pushNotificationMessage.setPushContent(content);
                int conversationType = rcJson.optInt("conversationType");
                pushNotificationMessage.setConversationType(RongPushClient.ConversationType.setValue(conversationType));
                int sourceType = rcJson.optInt("sourceType");
                pushNotificationMessage.setSourceType(this.getType(sourceType));
                pushNotificationMessage.setSenderId(rcJson.optString("fromUserId"));
                pushNotificationMessage.setObjectName(rcJson.optString("objectName"));
                pushNotificationMessage.setPushId(rcJson.optString("id"));
                pushNotificationMessage.setToId(rcJson.optString("tId"));
                pushNotificationMessage.setTargetId(rcJson.optString("targetId"));
                String appData = params.get("appData");
                if (appData != null) {
                    pushNotificationMessage.setPushData(appData);
                }
            }
            catch (JSONException e) {
                RLog.e("PushUtils", "transformToPushMessage:" + e.getMessage());
                pushNotificationMessage = null;
            }
        }
        return pushNotificationMessage;
    }

    private PushNotificationMessage.PushSourceType getType(int type) {
        for (PushNotificationMessage.PushSourceType sourceType : PushNotificationMessage.PushSourceType.values()) {
            if (sourceType.ordinal() != type) continue;
            return sourceType;
        }
        return PushNotificationMessage.PushSourceType.LOCAL_MESSAGE;
    }
}

