/*
 * Decompiled with CFR 0.152.
 */
package io.rong.push.platform.oppo;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import com.heytap.msp.push.HeytapPushManager;
import com.heytap.msp.push.callback.ICallBackResultService;
import io.rong.push.PushErrorCode;
import io.rong.push.PushManager;
import io.rong.push.PushType;
import io.rong.push.common.RLog;
import io.rong.push.platform.IPush;
import io.rong.push.pushconfig.PushConfig;

public class OppoPush
implements IPush {
    private final String TAG = OppoPush.class.getSimpleName();

    @Override
    public void register(final Context context, PushConfig pushConfig) {
        NotificationManager nm;
        HeytapPushManager.init((Context)context, (boolean)true);
        if (!HeytapPushManager.isSupportPush()) {
            RLog.e(this.TAG, "the phone is not support oppo push!");
            PushManager.getInstance().onErrorResponse(context, PushType.OPPO, "request_token", PushErrorCode.NOT_SUPPORT_BY_OFFICIAL_PUSH.getCode());
            return;
        }
        RLog.d(this.TAG, "Oppo push start to register");
        HeytapPushManager.register((Context)context.getApplicationContext(), (String)pushConfig.getOppoAppKey(), (String)pushConfig.getOppoAppSecret(), (ICallBackResultService)new ICallBackResultService(){

            public void onRegister(int responseCode, String registerID) {
                RLog.d(OppoPush.this.TAG, "Oppo Push onRegister responseCode " + String.valueOf(responseCode) + ",registerID:" + registerID);
                if (responseCode == 0) {
                    PushManager.getInstance().onReceiveToken(context, PushType.OPPO, registerID);
                } else {
                    PushManager.getInstance().onErrorResponse(context, PushType.OPPO, "request_token", responseCode);
                }
            }

            public void onUnRegister(int responseCode) {
                RLog.d(OppoPush.this.TAG, "OPPO Push onUnRegister - responseCode:" + responseCode);
            }

            public void onSetPushTime(int responseCode, String pushTime) {
                RLog.d(OppoPush.this.TAG, "OPPO Push onSetPushTime - responseCode:" + responseCode + ",pushTime:" + pushTime);
            }

            public void onGetPushStatus(int responseCode, int status) {
                RLog.d(OppoPush.this.TAG, "OPPO Push onGetPushStatus - responseCode:" + responseCode + ",status:" + status);
            }

            public void onGetNotificationStatus(int responseCode, int status) {
                RLog.d(OppoPush.this.TAG, "OPPO Push onGetNotificationStatus - responseCode:" + responseCode + ",status:" + status);
            }
        });
        if (Build.VERSION.SDK_INT >= 26 && (nm = (NotificationManager)context.getSystemService("notification")) != null) {
            int importance = 3;
            String channelName = context.getResources().getString(context.getResources().getIdentifier("rc_notification_channel_name", "string", context.getPackageName()));
            NotificationChannel notificationChannel = new NotificationChannel("rc_notification_id", (CharSequence)channelName, importance);
            notificationChannel.enableLights(true);
            notificationChannel.setLightColor(-16711936);
            nm.createNotificationChannel(notificationChannel);
        }
    }
}

