/*
 * Decompiled with CFR 0.152.
 */
package io.rong.push.platform.hms;

import android.content.Context;
import android.os.Looper;
import android.text.TextUtils;
import com.huawei.agconnect.config.AGConnectServicesConfig;
import com.huawei.hms.aaid.HmsInstanceId;
import com.huawei.hms.common.ApiException;
import io.rong.push.PushManager;
import io.rong.push.PushType;
import io.rong.push.common.RLog;
import io.rong.push.platform.IPush;
import io.rong.push.pushconfig.PushConfig;

public class HWPush
implements IPush {
    private static final String TAG = HWPush.class.getSimpleName();

    @Override
    public void register(final Context context, PushConfig pushConfig) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            this.action(context);
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    HWPush.this.action(context);
                }
            }).start();
        }
    }

    public void action(Context context) {
        RLog.d(TAG, "HMS start get token");
        try {
            String appId = AGConnectServicesConfig.fromContext((Context)context).getString("client/app_id");
            String pushtoken = HmsInstanceId.getInstance((Context)context).getToken(appId, "HCM");
            if (!TextUtils.isEmpty((CharSequence)pushtoken)) {
                PushManager.getInstance().onReceiveToken(context, PushType.HUAWEI, pushtoken);
            }
        }
        catch (ApiException e) {
            PushManager.getInstance().onErrorResponse(context, PushType.HUAWEI, "request_token", e.getStatusCode());
            RLog.i(TAG, "getToken failed, " + (Object)((Object)e));
        }
    }
}

