/*
 * Decompiled with CFR 0.152.
 */
package io.rong.push.platform.google;

import android.content.Context;
import com.google.android.gms.iid.InstanceID;
import io.rong.push.PushErrorCode;
import io.rong.push.PushManager;
import io.rong.push.PushType;
import io.rong.push.common.RLog;
import io.rong.push.core.PushUtils;
import io.rong.push.platform.IPush;
import io.rong.push.pushconfig.PushConfig;
import java.io.IOException;

public class GCMPush
implements IPush {
    private final String TAG = GCMPush.class.getSimpleName();

    @Override
    public void register(Context context, PushConfig pushConfig) {
        long result = PushUtils.checkPlayServices(context);
        if (result != 0L) {
            PushManager.getInstance().onErrorResponse(context, PushType.GOOGLE_GCM, "checkPlayServices", result);
        } else {
            InstanceID instanceID = InstanceID.getInstance((Context)context);
            try {
                String token = instanceID.getToken(context.getResources().getString(context.getResources().getIdentifier("gcm_defaultSenderId", "string", context.getPackageName())), "GCM", null);
                PushManager.getInstance().onReceiveToken(context, PushType.GOOGLE_GCM, token);
            }
            catch (IOException e) {
                RLog.e(this.TAG, e.getMessage());
                PushManager.getInstance().onErrorResponse(context, PushType.GOOGLE_GCM, "checkPlayServices", PushErrorCode.IO_EXCEPTION.getCode());
            }
        }
    }
}

