/*
 * Decompiled with CFR 0.152.
 */
package io.rong.push.notification;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextUtils;
import io.rong.imlib.common.DeviceUtils;
import io.rong.push.RongPushClient;
import io.rong.push.common.PushCacheHelper;
import io.rong.push.common.RLog;
import io.rong.push.notification.PushNotificationMessage;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class RongNotificationInterface {
    private static final String TAG = "RongNotificationInterface";
    private static HashMap<String, List<PushNotificationMessage>> messageCache = new HashMap();
    private static int NOTIFICATION_ID = 1000;
    private static int PUSH_SERVICE_NOTIFICATION_ID = 2000;
    private static int VOIP_NOTIFICATION_ID = 3000;
    private static final int NEW_NOTIFICATION_LEVEL = 11;
    private static final int PUSH_REQUEST_CODE = 200;
    private static final int NEGLECT_TIME = 3000;
    private static long lastNotificationTimestamp;
    private static Uri mSound;
    private static boolean recallUpdate;

    public static void sendNotification(Context context, PushNotificationMessage message) {
        RongNotificationInterface.sendNotification(context, message, 0);
    }

    public static void sendNotification(Context context, PushNotificationMessage message, int left) {
        String title;
        if (messageCache == null) {
            messageCache = new HashMap();
        }
        RongPushClient.ConversationType conversationType = message.getConversationType();
        String objName = message.getObjectName();
        String content = "";
        Integer notificationId = null;
        boolean isMulti = false;
        int requestCode = 200;
        SoundType soundType = SoundType.DEFAULT;
        RLog.i(TAG, "sendNotification() messageType: " + (Object)((Object)message.getConversationType()) + " messagePushContent: " + message.getPushContent() + " messageObjectName: " + message.getObjectName());
        if (TextUtils.isEmpty((CharSequence)objName) || conversationType == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - lastNotificationTimestamp < 3000L) {
            soundType = SoundType.SILENT;
        } else {
            lastNotificationTimestamp = now;
        }
        if (conversationType.equals((Object)RongPushClient.ConversationType.SYSTEM) || conversationType.equals((Object)RongPushClient.ConversationType.PUSH_SERVICE)) {
            title = message.getPushTitle();
            if (TextUtils.isEmpty((CharSequence)title)) {
                title = (String)context.getPackageManager().getApplicationLabel(context.getApplicationInfo());
            }
            content = message.getPushContent();
            requestCode = 300;
            try {
                notificationId = Integer.parseInt(message.getNotificationId());
            }
            catch (Exception e) {
                RLog.d(TAG, "parse notificationId exception:" + e.toString());
            }
            if (notificationId == null) {
                notificationId = PUSH_SERVICE_NOTIFICATION_ID;
                message.setNotificationId(notificationId.toString());
                ++PUSH_SERVICE_NOTIFICATION_ID;
            }
        } else if (objName != null && (objName.equals("RC:VCInvite") || objName.equals("RC:VCModifyMem") || objName.equals("RC:VCHangup"))) {
            if (objName.equals("RC:VCHangup")) {
                RongNotificationInterface.removeNotification(context, VOIP_NOTIFICATION_ID);
                return;
            }
            try {
                notificationId = Integer.parseInt(message.getNotificationId());
            }
            catch (Exception e) {
                RLog.d(TAG, "parse notificationId exception:" + e.toString());
            }
            if (notificationId == null) {
                notificationId = VOIP_NOTIFICATION_ID;
                message.setNotificationId(notificationId.toString());
            }
            soundType = SoundType.VOIP;
            requestCode = 400;
            title = message.getPushTitle();
            if (TextUtils.isEmpty((CharSequence)title) && message.isShowDetail()) {
                title = message.getSenderName();
            } else if (!message.isShowDetail()) {
                title = null;
            }
            content = message.getPushContent();
        } else {
            List<PushNotificationMessage> messages = messageCache.get(message.getTargetId());
            if (messages == null) {
                messages = new ArrayList<PushNotificationMessage>();
                messages.add(message);
                messageCache.put(message.getTargetId(), messages);
            } else if (objName.equals("RC:RcNtf")) {
                for (int i = messages.size() - 1; i >= 0; --i) {
                    if (messages.get(i) == null || messages.get(i).getPushId() == null || !messages.get(i).getPushId().equals(message.getPushId())) continue;
                    try {
                        notificationId = Integer.parseInt(messages.get(i).getNotificationId());
                    }
                    catch (Exception e) {
                        RLog.d(TAG, "parse notificationId exception:" + e.toString());
                    }
                    messages.remove(messages.get(i));
                    break;
                }
                if (messages.size() == 0) {
                    if (messageCache.size() == 1) {
                        messages.add(message);
                    } else {
                        messageCache.remove(message.getTargetId());
                        if (messageCache.size() == 1) {
                            recallUpdate = true;
                        }
                    }
                }
            } else {
                if (messages.get(messages.size() - 1).getObjectName().equals("RC:RcNtf")) {
                    messages.remove(messages.size() - 1);
                }
                messages.add(message);
            }
            if (messageCache.size() > 1) {
                isMulti = true;
            }
            if (TextUtils.isEmpty((CharSequence)(title = message.getPushTitle())) && message.isShowDetail()) {
                title = message.getTargetUserName();
            } else if (!message.isShowDetail()) {
                title = null;
            }
            try {
                notificationId = Integer.parseInt(message.getNotificationId());
            }
            catch (Exception e) {
                RLog.d(TAG, "parse notificationId exception:" + e.toString());
            }
            content = message.getPushContent();
            if (notificationId == null) {
                notificationId = NOTIFICATION_ID;
                message.setNotificationId(notificationId.toString());
                ++NOTIFICATION_ID;
            }
        }
        if (left > 0) {
            return;
        }
        PendingIntent intent = recallUpdate ? RongNotificationInterface.updateRecallPendingIntent(context, requestCode, isMulti) : RongNotificationInterface.createPendingIntent(context, message, requestCode, isMulti);
        NotificationManager nm = (NotificationManager)context.getSystemService("notification");
        Notification notification = null;
        if (Build.VERSION.SDK_INT >= 26) {
            String channelId = RongNotificationInterface.getChannelId(message);
            NotificationChannel notificationChannel = nm.getNotificationChannel(channelId);
            if (notificationChannel == null) {
                int importance = 3;
                String channelName = context.getResources().getString(context.getResources().getIdentifier("rc_notification_channel_name", "string", context.getPackageName()));
                notificationChannel = new NotificationChannel("rc_notification_id", (CharSequence)channelName, importance);
                notificationChannel.enableLights(true);
                notificationChannel.setLightColor(-16711936);
                notification = RongNotificationInterface.createNotification(context, title, intent, content, soundType, notificationChannel.getId());
                if (notification != null && notification.sound != null) {
                    notificationChannel.setSound(notification.sound, null);
                }
            } else {
                notification = RongNotificationInterface.createNotification(context, title, intent, content, soundType, notificationChannel.getId());
            }
            nm.createNotificationChannel(notificationChannel);
        } else {
            notification = RongNotificationInterface.createNotification(context, title, intent, content, soundType, "");
        }
        if (notification != null) {
            RLog.i(TAG, "sendNotification() real notify! notificationId: " + notificationId + " notification: " + notification.toString());
            nm.notify(notificationId.intValue(), notification);
        }
    }

    private static String getChannelId(PushNotificationMessage message) {
        String os = DeviceUtils.getDeviceManufacturer().toLowerCase();
        String channelId = null;
        if (Build.VERSION.SDK_INT >= 26) {
            if (os.contains("Xiaomi".toLowerCase())) {
                channelId = message.getChannelIdMi();
            } else if (os.contains("HUAWEI".toLowerCase())) {
                channelId = message.getChannelIdHW();
            } else if (os.contains("oppo".toLowerCase())) {
                channelId = message.getChannelIdOPPO();
            }
        }
        return channelId;
    }

    private static PendingIntent updateRecallPendingIntent(Context context, int requestCode, boolean isMulti) {
        Collection<List<PushNotificationMessage>> collection = messageCache.values();
        List<PushNotificationMessage> msg = collection.iterator().next();
        PushNotificationMessage notificationMessage = msg.get(0);
        Intent intent = new Intent();
        intent.setAction("io.rong.push.intent.MESSAGE_CLICKED");
        intent.putExtra("message", (Parcelable)notificationMessage);
        intent.putExtra("isMulti", isMulti);
        intent.setPackage(context.getPackageName());
        return PendingIntent.getBroadcast((Context)context, (int)requestCode, (Intent)intent, (int)0x8000000);
    }

    public static void removeAllNotification(Context context) {
        messageCache.clear();
        NotificationManager nm = (NotificationManager)context.getSystemService("notification");
        try {
            nm.cancelAll();
        }
        catch (Exception e) {
            RLog.e(TAG, "removeAllNotification" + e.getMessage());
        }
        NOTIFICATION_ID = 1000;
    }

    public static void removeAllPushNotification(Context context) {
        messageCache.clear();
        NotificationManager nm = (NotificationManager)context.getSystemService("notification");
        nm.cancel(NOTIFICATION_ID);
        nm.cancel(VOIP_NOTIFICATION_ID);
    }

    public static void removeAllPushServiceNotification(Context context) {
        NotificationManager nm = (NotificationManager)context.getSystemService("notification");
        for (int i = PUSH_SERVICE_NOTIFICATION_ID; i >= 1000; --i) {
            nm.cancel(i);
        }
        PUSH_SERVICE_NOTIFICATION_ID = 2000;
    }

    public static void removeNotification(Context context, int notificationId) {
        if (notificationId < 0) {
            return;
        }
        if (notificationId >= NOTIFICATION_ID && notificationId < PUSH_SERVICE_NOTIFICATION_ID) {
            messageCache.clear();
        }
        NotificationManager nm = (NotificationManager)context.getSystemService("notification");
        nm.cancel(notificationId);
    }

    private static PendingIntent createPendingIntent(Context context, PushNotificationMessage message, int requestCode, boolean isMulti) {
        Intent intent = new Intent();
        intent.setAction("io.rong.push.intent.MESSAGE_CLICKED");
        intent.putExtra("message", (Parcelable)message);
        intent.putExtra("isMulti", isMulti);
        intent.setPackage(context.getPackageName());
        return PendingIntent.getBroadcast((Context)context, (int)requestCode, (Intent)intent, (int)0x8000000);
    }

    private static String getNotificationContent(Context context) {
        String content;
        String rc_notification_new_msg = context.getResources().getString(context.getResources().getIdentifier("rc_notification_new_msg", "string", context.getPackageName()));
        String rc_notification_new_plural_msg = context.getResources().getString(context.getResources().getIdentifier("rc_notification_new_plural_msg", "string", context.getPackageName()));
        if (messageCache.size() == 1) {
            Collection<List<PushNotificationMessage>> collection = messageCache.values();
            List<PushNotificationMessage> msg = collection.iterator().next();
            PushNotificationMessage notificationMessage = msg.get(0);
            if (msg.size() == 1) {
                content = notificationMessage.getPushContent();
            } else if (msg.get(msg.size() - 1).getObjectName().equals("RC:RcNtf")) {
                notificationMessage = msg.get(msg.size() - 1);
                content = notificationMessage.getPushContent();
            } else {
                content = String.format(rc_notification_new_msg, notificationMessage.getTargetUserName(), msg.size());
            }
        } else {
            int count = 0;
            Collection<List<PushNotificationMessage>> collection = messageCache.values();
            for (List<PushNotificationMessage> msg : collection) {
                count += msg.size();
            }
            content = String.format(rc_notification_new_plural_msg, messageCache.size(), count);
        }
        return content;
    }

    private static String getNotificationTitle(Context context) {
        String title;
        if (messageCache.size() == 1) {
            Collection<List<PushNotificationMessage>> collection = messageCache.values();
            List<PushNotificationMessage> msg = collection.iterator().next();
            PushNotificationMessage notificationMessage = msg.get(0);
            title = notificationMessage.getTargetUserName();
        } else {
            title = (String)context.getPackageManager().getApplicationLabel(context.getApplicationInfo());
        }
        return title;
    }

    public static Notification createNotification(Context context, String title, PendingIntent pendingIntent, String content, SoundType soundType, boolean isShowDetail) {
        Notification notification;
        String tickerText = context.getResources().getString(context.getResources().getIdentifier("rc_notification_ticker_text", "string", context.getPackageName()));
        if (TextUtils.isEmpty((CharSequence)content)) {
            content = RongNotificationInterface.getNotificationContent(context);
        }
        if (Build.VERSION.SDK_INT < 11) {
            try {
                notification = new Notification(context.getApplicationInfo().icon, (CharSequence)tickerText, System.currentTimeMillis());
                Class<Notification> classType = Notification.class;
                Method method = classType.getMethod("setLatestEventInfo", Context.class, CharSequence.class, CharSequence.class, PendingIntent.class);
                method.invoke((Object)notification, context, title, content, pendingIntent);
                notification.flags = 16;
                notification.defaults = -1;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        boolean isLollipop = Build.VERSION.SDK_INT >= 21;
        int smallIcon = context.getResources().getIdentifier("notification_small_icon", "drawable", context.getPackageName());
        if (smallIcon <= 0 || !isLollipop) {
            smallIcon = context.getApplicationInfo().icon;
        }
        int defaults = 1;
        Uri sound = null;
        if (soundType.equals((Object)SoundType.SILENT)) {
            defaults = 4;
        } else if (soundType.equals((Object)SoundType.VOIP)) {
            defaults = 6;
            sound = RingtoneManager.getDefaultUri((int)1);
        } else {
            sound = RingtoneManager.getDefaultUri((int)2);
        }
        Drawable loadIcon = context.getApplicationInfo().loadIcon(context.getPackageManager());
        Bitmap appIcon = null;
        try {
            if (Build.VERSION.SDK_INT >= 26 && loadIcon instanceof AdaptiveIconDrawable) {
                appIcon = Bitmap.createBitmap((int)loadIcon.getIntrinsicWidth(), (int)loadIcon.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(appIcon);
                loadIcon.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                loadIcon.draw(canvas);
            } else {
                appIcon = ((BitmapDrawable)loadIcon).getBitmap();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Notification.Builder builder = new Notification.Builder(context);
        builder.setLargeIcon(appIcon);
        if (!soundType.equals((Object)SoundType.SILENT)) {
            builder.setVibrate(new long[]{0L, 200L, 250L, 200L});
        }
        builder.setSmallIcon(smallIcon);
        builder.setTicker((CharSequence)tickerText);
        if (PushCacheHelper.getInstance().getPushContentShowStatus(context) || isShowDetail) {
            builder.setContentTitle((CharSequence)title);
            builder.setContentText((CharSequence)content);
        } else {
            String name;
            PackageManager pm = context.getPackageManager();
            try {
                name = pm.getApplicationLabel(pm.getApplicationInfo(context.getPackageName(), 128)).toString();
            }
            catch (PackageManager.NameNotFoundException e) {
                name = "";
            }
            builder.setContentTitle((CharSequence)name);
            builder.setContentText((CharSequence)tickerText);
        }
        builder.setContentIntent(pendingIntent);
        builder.setLights(-16711936, 3000, 3000);
        builder.setAutoCancel(true);
        if (Build.VERSION.SDK_INT >= 26) {
            builder.setChannelId("rc_notification_id");
        }
        if (mSound == null || TextUtils.isEmpty((CharSequence)mSound.toString())) {
            builder.setSound(sound);
            builder.setDefaults(defaults);
        } else {
            builder.setSound(mSound);
        }
        notification = builder.build();
        notification.flags = 1;
        return notification;
    }

    public static Notification createNotification(Context context, String title, PendingIntent pendingIntent, String content, SoundType soundType, String channelId) {
        Notification notification;
        String tickerText = context.getResources().getString(context.getResources().getIdentifier("rc_notification_ticker_text", "string", context.getPackageName()));
        if (TextUtils.isEmpty((CharSequence)content)) {
            content = RongNotificationInterface.getNotificationContent(context);
        }
        if (Build.VERSION.SDK_INT < 11) {
            try {
                notification = new Notification(context.getApplicationInfo().icon, (CharSequence)tickerText, System.currentTimeMillis());
                Class<Notification> classType = Notification.class;
                Method method = classType.getMethod("setLatestEventInfo", Context.class, CharSequence.class, CharSequence.class, PendingIntent.class);
                method.invoke((Object)notification, context, title, content, pendingIntent);
                notification.flags = 16;
                notification.defaults = -1;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        boolean isLollipop = Build.VERSION.SDK_INT >= 21;
        int smallIcon = context.getResources().getIdentifier("notification_small_icon", "drawable", context.getPackageName());
        if (smallIcon <= 0 || !isLollipop) {
            smallIcon = context.getApplicationInfo().icon;
        }
        int defaults = 1;
        Uri sound = null;
        if (soundType.equals((Object)SoundType.SILENT)) {
            defaults = 4;
        } else if (soundType.equals((Object)SoundType.VOIP)) {
            defaults = 6;
            sound = RingtoneManager.getDefaultUri((int)1);
        } else {
            sound = RingtoneManager.getDefaultUri((int)2);
        }
        Drawable loadIcon = context.getApplicationInfo().loadIcon(context.getPackageManager());
        Bitmap appIcon = null;
        try {
            if (Build.VERSION.SDK_INT >= 26 && loadIcon instanceof AdaptiveIconDrawable) {
                appIcon = Bitmap.createBitmap((int)loadIcon.getIntrinsicWidth(), (int)loadIcon.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(appIcon);
                loadIcon.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                loadIcon.draw(canvas);
            } else {
                appIcon = ((BitmapDrawable)loadIcon).getBitmap();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Notification.Builder builder = new Notification.Builder(context);
        builder.setLargeIcon(appIcon);
        if (!soundType.equals((Object)SoundType.SILENT)) {
            builder.setVibrate(new long[]{0L, 200L, 250L, 200L});
        }
        builder.setSmallIcon(smallIcon);
        builder.setTicker((CharSequence)tickerText);
        builder.setContentTitle((CharSequence)title);
        builder.setContentText((CharSequence)content);
        builder.setContentIntent(pendingIntent);
        builder.setLights(-16711936, 3000, 3000);
        builder.setAutoCancel(true);
        if (Build.VERSION.SDK_INT >= 26) {
            if (!TextUtils.isEmpty((CharSequence)channelId)) {
                builder.setChannelId(channelId);
            } else {
                builder.setChannelId("rc_notification_id");
            }
        }
        if (mSound == null || TextUtils.isEmpty((CharSequence)mSound.toString())) {
            builder.setSound(sound);
            builder.setDefaults(defaults);
        } else {
            builder.setSound(mSound);
        }
        notification = builder.build();
        notification.flags = 1;
        return notification;
    }

    public static void setNotificationSound(Uri uri) {
        mSound = uri;
    }

    static {
        recallUpdate = false;
    }

    public static enum SoundType {
        DEFAULT(0),
        SILENT(1),
        VOIP(2);

        int value;

        private SoundType(int v) {
            this.value = v;
        }
    }
}

