/*
 * Decompiled with CFR 0.152.
 */
package io.rong.push.notification;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextUtils;
import io.rong.push.PushErrorCode;
import io.rong.push.PushType;
import io.rong.push.RongPushClient;
import io.rong.push.common.RLog;
import io.rong.push.notification.PushNotificationMessage;
import io.rong.push.notification.RongNotificationInterface;

public abstract class PushMessageReceiver
extends BroadcastReceiver {
    private static final String TAG = "PushMessageReceiver";

    public final void onReceive(Context context, Intent intent) {
        RLog.d(TAG, "onReceive.action:" + intent.getAction());
        if (intent.getAction() == null) {
            RLog.e(TAG, "the intent action is null, return directly. ");
            return;
        }
        String name = intent.getStringExtra("pushType");
        int left = intent.getIntExtra("left", 0);
        PushNotificationMessage message = (PushNotificationMessage)intent.getParcelableExtra("message");
        if (message == null && !intent.getAction().equals("io.rong.push.intent.THIRD_PARTY_PUSH_STATE")) {
            RLog.e(TAG, "message is null. Return directly!");
            return;
        }
        PushType pushType = PushType.getType(name);
        switch (intent.getAction()) {
            case "io.rong.push.intent.MESSAGE_ARRIVED": {
                if (this.onNotificationMessageArrived(context, pushType, message) || !pushType.equals((Object)PushType.RONG) && !pushType.equals((Object)PushType.GOOGLE_FCM) && !pushType.equals((Object)PushType.GOOGLE_GCM) || message == null || this.handleVoIPNotification(context, message, intent.getAction())) break;
                RongNotificationInterface.sendNotification(context, message, left);
                break;
            }
            case "io.rong.push.intent.MESSAGE_CLICKED": {
                if (message != null && !TextUtils.isEmpty((CharSequence)message.getPushId())) {
                    RongPushClient.recordNotificationEvent(message);
                }
                if (this.onNotificationMessageClicked(context, pushType, message) || message == null || this.handleVoIPNotification(context, message, intent.getAction())) break;
                boolean isMulti = intent.getBooleanExtra("isMulti", false);
                this.handleNotificationClickEvent(context, isMulti, message);
                break;
            }
            case "io.rong.push.intent.THIRD_PARTY_PUSH_STATE": {
                String action = intent.getStringExtra("action");
                long resultCode = intent.getLongExtra("resultCode", (long)PushErrorCode.UNKNOWN.getCode());
                this.onThirdPartyPushState(pushType, action, resultCode);
                break;
            }
            default: {
                RLog.e(TAG, "Unknown action, do nothing!");
            }
        }
    }

    public abstract boolean onNotificationMessageArrived(Context var1, PushType var2, PushNotificationMessage var3);

    public abstract boolean onNotificationMessageClicked(Context var1, PushType var2, PushNotificationMessage var3);

    public void onThirdPartyPushState(PushType pushType, String action, long resultCode) {
        RLog.e(TAG, "onThirdPartyPushState pushType: " + (Object)((Object)pushType) + " action: " + action + " resultCode: " + resultCode);
    }

    private void handleNotificationClickEvent(Context context, boolean isMulti, PushNotificationMessage notificationMessage) {
        String isFromPush = notificationMessage.getSourceType().equals((Object)PushNotificationMessage.PushSourceType.FROM_OFFLINE_MESSAGE) || notificationMessage.getSourceType().equals((Object)PushNotificationMessage.PushSourceType.FROM_ADMIN) ? "true" : "false";
        Intent intent = new Intent();
        intent.setFlags(0x10000000);
        Uri.Builder builder = Uri.parse((String)("rong://" + context.getPackageName())).buildUpon();
        if (notificationMessage.getSourceType().equals((Object)PushNotificationMessage.PushSourceType.FROM_ADMIN)) {
            builder.appendPath("push_message").appendQueryParameter("targetId", notificationMessage.getTargetId()).appendQueryParameter("pushContent", notificationMessage.getPushContent()).appendQueryParameter("pushData", notificationMessage.getPushData()).appendQueryParameter("extra", notificationMessage.getExtra()).appendQueryParameter("isFromPush", isFromPush);
        } else if (isMulti) {
            builder.appendPath("conversationlist").appendQueryParameter("isFromPush", isFromPush);
        } else {
            builder.appendPath("conversation").appendPath(notificationMessage.getConversationType().getName()).appendQueryParameter("targetId", notificationMessage.getTargetId()).appendQueryParameter("title", TextUtils.isEmpty((CharSequence)notificationMessage.getPushTitle()) ? notificationMessage.getTargetUserName() : notificationMessage.getPushTitle()).appendQueryParameter("isFromPush", isFromPush);
        }
        intent.setData(builder.build());
        intent.setPackage(context.getPackageName());
        context.startActivity(intent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleVoIPNotification(Context context, PushNotificationMessage notificationMessage, String type) {
        String objName = notificationMessage.getObjectName();
        if (objName == null || !objName.equals("RC:VCInvite")) return false;
        if (Build.VERSION.SDK_INT >= 29) {
            Intent intent = new Intent();
            intent.setPackage(context.getPackageName());
            intent.putExtra("message", (Parcelable)notificationMessage);
            if ("io.rong.push.intent.MESSAGE_ARRIVED".equals(type)) {
                intent.setAction("action.push.CallInviteMessage");
                context.sendBroadcast(intent);
                return true;
            } else {
                if (!"io.rong.push.intent.MESSAGE_CLICKED".equals(type)) return false;
                intent.setAction("action.push.CallInviteMessage.CLICKED");
                context.sendBroadcast(intent);
            }
            return true;
        } else {
            RLog.d(TAG, "handle VoIP event.");
            Intent intent = new Intent();
            intent.setFlags(0x10000000);
            Uri uri = Uri.parse((String)("rong://" + context.getPackageName())).buildUpon().appendPath("conversationlist").appendQueryParameter("isFromPush", "false").build();
            intent.setData(uri);
            intent.setPackage(context.getPackageName());
            context.startActivity(intent);
        }
        return true;
    }
}

