/*
 * Decompiled with CFR 0.152.
 */
package io.rong.push.core;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.common.GoogleApiAvailability;
import io.rong.common.rlog.RLog;
import io.rong.imlib.common.DeviceUtils;
import io.rong.push.PushType;
import io.rong.push.RongPushClient;
import io.rong.push.notification.PushNotificationMessage;
import io.rong.push.pushconfig.PushConfig;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class PushUtils {
    private static final String PUSH_NAVI = "nav.cn.ronghub.com";
    private static final String PUSH_NAVI_BACKUP = "nav2-cn.ronghub.com";

    public static String getDefaultNavi() {
        return "nav.cn.ronghub.com;nav2-cn.ronghub.com";
    }

    public static PushType getPreferPushType(Context context, PushConfig pushConfig) {
        String os = DeviceUtils.getDeviceManufacturer().toLowerCase();
        Set<PushType> pushTypes = pushConfig.getEnabledPushTypes();
        if (os.contains("Xiaomi".toLowerCase()) && pushTypes.contains((Object)PushType.XIAOMI)) {
            return PushType.XIAOMI;
        }
        if (os.contains("HUAWEI".toLowerCase()) && pushTypes.contains((Object)PushType.HUAWEI)) {
            return PushType.HUAWEI;
        }
        if (os.contains("Meizu".toLowerCase()) && pushTypes.contains((Object)PushType.MEIZU)) {
            return PushType.MEIZU;
        }
        if (os.contains("oppo".toLowerCase()) && pushTypes.contains((Object)PushType.OPPO)) {
            return PushType.OPPO;
        }
        if (os.contains("VIVO".toLowerCase()) && pushTypes.contains((Object)PushType.VIVO)) {
            return PushType.VIVO;
        }
        if (!pushTypes.contains((Object)PushType.GOOGLE_GCM) && !pushTypes.contains((Object)PushType.GOOGLE_FCM)) {
            return PushType.RONG;
        }
        return PushType.UNKNOWN;
    }

    public static long checkPlayServices(Context context) {
        GoogleApiAvailability apiAvailability = GoogleApiAvailability.getInstance();
        return apiAvailability.isGooglePlayServicesAvailable(context);
    }

    public static PushNotificationMessage transformToPushMessage(String jsonStr) {
        try {
            String rcjson;
            JSONObject jsonObject = new JSONObject(jsonStr);
            PushNotificationMessage pushNotificationMessage = new PushNotificationMessage();
            String channelType = jsonObject.optString("channelType");
            int typeValue = 0;
            if (!TextUtils.isEmpty((CharSequence)channelType)) {
                try {
                    typeValue = Integer.parseInt(channelType);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            RongPushClient.ConversationType conversationType = RongPushClient.ConversationType.setValue(typeValue);
            pushNotificationMessage.setConversationType(conversationType);
            if (conversationType.equals((Object)RongPushClient.ConversationType.DISCUSSION) || conversationType.equals((Object)RongPushClient.ConversationType.GROUP) || conversationType.equals((Object)RongPushClient.ConversationType.CHATROOM)) {
                pushNotificationMessage.setTargetId(jsonObject.optString("channelId"));
                pushNotificationMessage.setTargetUserName(jsonObject.optString("channelName"));
            } else {
                pushNotificationMessage.setTargetId(jsonObject.optString("fromUserId"));
                pushNotificationMessage.setTargetUserName(jsonObject.optString("fromUserName"));
            }
            pushNotificationMessage.setReceivedTime(jsonObject.optLong("timeStamp"));
            pushNotificationMessage.setObjectName(jsonObject.optString("objectName"));
            pushNotificationMessage.setSenderId(jsonObject.optString("fromUserId"));
            pushNotificationMessage.setSenderName(jsonObject.optString("fromUserName"));
            pushNotificationMessage.setSenderPortrait(TextUtils.isEmpty((CharSequence)jsonObject.optString("fromUserPo")) ? null : Uri.parse((String)jsonObject.optString("fromUserPo")));
            pushNotificationMessage.setPushTitle(jsonObject.optString("title"));
            pushNotificationMessage.setPushContent(jsonObject.optString("content"));
            pushNotificationMessage.setPushData(jsonObject.optString("appData"));
            pushNotificationMessage.setPushFlag("true");
            String toId = "";
            String type = "";
            String pushId = "";
            PushNotificationMessage.PushSourceType sourceType = PushNotificationMessage.PushSourceType.FROM_ADMIN;
            JSONObject temp = jsonObject.optJSONObject("rc");
            if (temp == null && (rcjson = jsonObject.optString("rc")) != null) {
                temp = new JSONObject(rcjson);
            }
            if (temp != null) {
                toId = temp.optString("tId");
                type = temp.optString("sourceType");
                pushId = temp.optString("id");
            }
            if (!TextUtils.isEmpty((CharSequence)type)) {
                sourceType = PushNotificationMessage.PushSourceType.values()[Integer.parseInt(type)];
            }
            pushNotificationMessage.setToId(toId);
            pushNotificationMessage.setSourceType(sourceType);
            pushNotificationMessage.setPushId(pushId);
            if (temp != null && temp.has("ext") && temp.getJSONObject("ext") != null) {
                pushNotificationMessage.setExtra(temp.getJSONObject("ext").toString());
            }
            return pushNotificationMessage;
        }
        catch (JSONException e) {
            RLog.e("PushUtils", e.getMessage());
            return null;
        }
    }

    public static String getPackageName(String str) {
        String packageName = "";
        try {
            JSONObject json = new JSONObject(str);
            packageName = json.optString("packageName");
        }
        catch (JSONException e) {
            RLog.e("PushUtils", "getPackageName", e);
        }
        return packageName;
    }
}

