/*
 * Decompiled with CFR 0.152.
 */
package io.rong.push.core;

import android.content.Context;
import android.os.Build;
import android.security.NetworkSecurityPolicy;
import android.text.TextUtils;
import io.rong.common.utils.SSLUtils;
import io.rong.imlib.common.DeviceUtils;
import io.rong.push.PushErrorCode;
import io.rong.push.common.PushCacheHelper;
import io.rong.push.common.RLog;
import io.rong.push.core.PushUtils;
import io.rong.push.pushconfig.PushNaviObserver;
import io.rong.push.rongpush.RongPushCacheHelper;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.json.JSONObject;

public class PushNaviClient {
    private static final String TAG = PushNaviClient.class.getSimpleName();
    private final String NAVI_SPLIT = ";";
    private final String IP_SPLIT = ",";
    private final String NAVI_PATH = "navipush.json";
    private Set<String> naviList = new LinkedHashSet<String>();
    private PushNaviObserver pushNaviObserver;
    private boolean isPushProcess;

    public void setPushNaviUrl(String naviAddress) {
        RLog.i(TAG, "setPushNaviUrl " + naviAddress);
        if (TextUtils.isEmpty((CharSequence)naviAddress)) {
            RLog.e(TAG, "navi address is empty! Use default navi address!");
            naviAddress = PushUtils.getDefaultNavi();
        }
        this.naviList.addAll(this.naviStrToList(naviAddress));
    }

    private List<String> naviStrToList(String naviStr) {
        if (TextUtils.isEmpty((CharSequence)naviStr)) {
            return new ArrayList<String>();
        }
        String[] naviArray = naviStr.split(";");
        ArrayList<String> list = new ArrayList<String>();
        if (naviArray.length > 0) {
            for (String navi : naviArray) {
                String current;
                if (TextUtils.isEmpty((CharSequence)navi) || list.contains(current = this.formatServerAddress(navi, "navipush.json"))) continue;
                list.add(current);
            }
        }
        return list;
    }

    private String formatServerAddress(String domain, String path) {
        String strFormat = domain.toLowerCase().startsWith("http") ? "%s/%s" : (Build.VERSION.SDK_INT >= 28 && !NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted() ? "https://%s/%s" : "http://%s/%s");
        return String.format(strFormat, domain, path);
    }

    public void getPushServerIPs(Context context, String appKey, boolean isPushProcess, PushNaviObserver observer) {
        this.pushNaviObserver = observer;
        this.isPushProcess = isPushProcess;
        if (isPushProcess && RongPushCacheHelper.getInstance().isCacheValid(context, appKey)) {
            observer.onSuccess(RongPushCacheHelper.getInstance().getCachedAddressList(context));
        } else if (!isPushProcess && PushCacheHelper.getInstance().isCacheValid(context, appKey)) {
            observer.onSuccess(PushCacheHelper.getInstance().getCachedAddressList(context));
        } else {
            this.connectToNavi(context, appKey);
        }
    }

    private void connectToNavi(Context context, String appKey) {
        String navi2;
        String tokenInNaviToken = PushCacheHelper.getInstance().getPushServerInfoInIMToken(context);
        ArrayList<String> combineList = new ArrayList<String>(this.naviStrToList(tokenInNaviToken));
        for (String navi2 : this.naviList) {
            if (combineList.contains(navi2)) continue;
            combineList.add(navi2);
        }
        Iterator iterator = combineList.iterator();
        while (iterator.hasNext() && !this.connect(context, navi2 = (String)iterator.next(), appKey, !iterator.hasNext())) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connect(Context context, String naviUrl, String appKey, boolean isLastNavi) {
        HttpURLConnection conn = null;
        BufferedInputStream responseStream = null;
        boolean result = false;
        String address = "";
        try {
            URL url = new URL(naviUrl);
            RLog.i(TAG, "navigation url : " + url);
            conn = this.createConnection(naviUrl);
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            conn.setUseCaches(false);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("appId", appKey);
            OutputStream os = conn.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
            String param = "deviceId=" + DeviceUtils.getDeviceId(context, appKey);
            writer.write(param);
            writer.flush();
            writer.close();
            os.close();
            conn.connect();
            int responseCode = conn.getResponseCode();
            if (responseCode >= 100 && responseCode <= 300) {
                int c;
                responseStream = new BufferedInputStream(conn.getInputStream());
                ByteArrayOutputStream responseData = new ByteArrayOutputStream(256);
                while ((c = responseStream.read()) != -1) {
                    responseData.write(c);
                }
                JSONObject responseDict = new JSONObject(responseData.toString("UTF-8"));
                boolean success = responseDict.optString("code").equalsIgnoreCase("200");
                if (success) {
                    String[] bsArray;
                    result = true;
                    ArrayList<String> addressList = new ArrayList<String>();
                    address = responseDict.optString("server");
                    addressList.add(address);
                    String bs = responseDict.optString("bs");
                    RLog.d(TAG, "server:" + address + ";bs server:" + bs);
                    if (!TextUtils.isEmpty((CharSequence)bs) && (bsArray = bs.split(",")).length > 0) {
                        for (String str : bsArray) {
                            addressList.add(str);
                        }
                    }
                    if (this.isPushProcess) {
                        RongPushCacheHelper.getInstance().cacheRongPushIPs(context, addressList, System.currentTimeMillis());
                    } else {
                        PushCacheHelper.getInstance().saveAllAddress(context, addressList, System.currentTimeMillis());
                    }
                    this.pushNaviObserver.onSuccess(addressList);
                } else if (this.pushNaviObserver != null && isLastNavi) {
                    RLog.e(TAG, "Fail to get navi. errorcode:" + responseCode);
                    this.pushNaviObserver.onError(PushErrorCode.IO_EXCEPTION);
                }
            }
        }
        catch (Exception e) {
            RLog.e(TAG, "Exception when get navigation address.Retry again.");
            if (this.pushNaviObserver != null && isLastNavi) {
                this.pushNaviObserver.onError(PushErrorCode.IO_EXCEPTION);
            }
            e.printStackTrace();
        }
        finally {
            if (responseStream != null) {
                try {
                    responseStream.close();
                }
                catch (IOException iOException) {}
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return result;
    }

    private HttpURLConnection createConnection(String urlStr) throws Exception {
        HttpURLConnection connection;
        if (urlStr.toLowerCase().startsWith("https")) {
            HostnameVerifier hostVerifier;
            URL url = new URL(urlStr);
            HttpsURLConnection c = (HttpsURLConnection)url.openConnection();
            SSLContext sslContext = SSLUtils.getSSLContext();
            if (sslContext != null) {
                c.setSSLSocketFactory(sslContext.getSocketFactory());
            }
            if ((hostVerifier = SSLUtils.getHostVerifier()) != null) {
                c.setHostnameVerifier(hostVerifier);
            }
            connection = c;
        } else {
            URL u = new URL(urlStr);
            connection = (HttpURLConnection)u.openConnection();
        }
        return connection;
    }
}

