/*
 * Decompiled with CFR 0.152.
 */
package io.rong.push;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextUtils;
import com.xiaomi.mipush.sdk.MiPushClient;
import io.rong.imlib.statistics.Statistics;
import io.rong.push.PushManager;
import io.rong.push.PushType;
import io.rong.push.common.PushCacheHelper;
import io.rong.push.common.RLog;
import io.rong.push.notification.PushNotificationMessage;
import io.rong.push.notification.RongNotificationInterface;
import io.rong.push.platform.IPush;
import io.rong.push.pushconfig.PushConfig;
import io.rong.push.pushconfig.PushFactory;
import io.rong.push.rongpush.PushReceiver;
import io.rong.push.rongpush.PushService;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class RongPushClient {
    private static final String TAG = RongPushClient.class.getSimpleName();
    private static final ArrayList<PushType> registeredType = new ArrayList();
    private static String miAppId;
    private static String miAppKey;
    private static String mzAppId;
    private static String mzAppKey;
    private static PushConfig pushConfig;

    @Deprecated
    public static void registerGCM(Context context) {
        registeredType.add(PushType.GOOGLE_GCM);
    }

    @Deprecated
    public static void registerFCM(Context context) {
        registeredType.add(PushType.GOOGLE_FCM);
    }

    @Deprecated
    public static void registerMiPush(Context context, String miAppId, String miAppKey) {
        if (TextUtils.isEmpty((CharSequence)miAppId) || TextUtils.isEmpty((CharSequence)miAppKey)) {
            throw new IllegalArgumentException("Failed registerMiPush. miAppId or miAppKey can't be empty.");
        }
        RongPushClient.miAppId = miAppId;
        RongPushClient.miAppKey = miAppKey;
        registeredType.add(PushType.XIAOMI);
    }

    @Deprecated
    public static void registerHWPush(Context context) {
        registeredType.add(PushType.HUAWEI);
    }

    @Deprecated
    public static void registerMZPush(Context context, String appId, String appKey) {
        if (TextUtils.isEmpty((CharSequence)appId) || TextUtils.isEmpty((CharSequence)appKey)) {
            throw new IllegalArgumentException("Failed registerMZPush. appKey or appId can't be empty.");
        }
        registeredType.add(PushType.MEIZU);
        mzAppId = appId;
        mzAppKey = appKey;
    }

    @Deprecated
    public static void resolveHWPushError(Activity activity, long errorCode) throws IllegalStateException {
        if (activity == null) {
            throw new IllegalStateException("resolve HWPush Error activity is null !");
        }
    }

    public static void resolveHMSCoreUpdate(Activity activity) throws IllegalStateException {
        if (activity == null) {
            throw new IllegalStateException("resolve HWPush Error activity is null !");
        }
        PushType currentPushType = PushManager.getInstance().getServerPushType();
        if (!PushCacheHelper.getInstance().isConfigDone((Context)activity) && currentPushType != null && currentPushType.getName().equals(PushType.HUAWEI.getName())) {
            IPush hwPush = PushFactory.getPushProcessorByType(PushType.HUAWEI);
            if (hwPush != null) {
                hwPush.register((Context)activity, PushManager.getInstance().getPushConfig());
            } else {
                RLog.e(TAG, "no register HWPush");
            }
        } else {
            RLog.i(TAG, "current pushType is " + (Object)((Object)currentPushType));
        }
    }

    public static void setPushConfig(PushConfig config) {
        pushConfig = config;
    }

    public static void init(Context context, String appKey) {
        RongPushClient.init(context, appKey, "");
    }

    public static void init(Context context, String appKey, String pushDomain) {
        if (TextUtils.isEmpty((CharSequence)appKey)) {
            throw new ExceptionInInitializerError("appKey can't be empty!");
        }
        if (pushConfig == null) {
            boolean isHWEnable = registeredType.contains((Object)PushType.HUAWEI);
            boolean isGCMEnable = registeredType.contains((Object)PushType.GOOGLE_GCM);
            boolean isFCMEnable = registeredType.contains((Object)PushType.GOOGLE_FCM);
            pushConfig = new PushConfig.Builder().enableHWPush(isHWEnable).enableMiPush(miAppId, miAppKey).enableMeiZuPush(mzAppId, mzAppKey).enableFCM(isFCMEnable).enableGCM(isGCMEnable).setAppKey(appKey).setPushNaviAddress(pushDomain).build();
        } else {
            pushConfig.setPushNaviAddress(pushDomain);
            pushConfig.setAppKey(appKey);
        }
        PushManager.getInstance().init(context, pushConfig);
    }

    public static void stopService(Context context) {
        try {
            if (!PushCacheHelper.getInstance().getConfigPushType(context).equals((Object)PushType.HUAWEI) && PushCacheHelper.getInstance().getConfigPushType(context).equals((Object)PushType.XIAOMI)) {
                MiPushClient.unregisterPush((Context)context);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            RLog.e(TAG, "stopService throw exception: " + e.getMessage());
        }
        ComponentName componentName = new ComponentName(context, PushReceiver.class);
        context.getPackageManager().setComponentEnabledSetting(componentName, 2, 1);
        Intent intent = new Intent(context, PushService.class);
        intent.setAction("io.rong.push.intent.action.UNINIT");
        PushService.enqueueWork(context, intent);
    }

    public static void redirected(Context context) {
        String pushTypeUsing = PushCacheHelper.getInstance().getConfigPushType(context).getName();
        if (TextUtils.isEmpty((CharSequence)pushTypeUsing)) {
            Intent intent = new Intent(context, PushService.class);
            intent.setAction("io.rong.push.intent.action.REDIRECT");
            PushService.enqueueWork(context, intent);
        }
    }

    public static void clearAllNotifications(Context context) {
        RLog.i(TAG, "clearAllNotifications");
        if (PushCacheHelper.getInstance().getConfigPushType(context).equals((Object)PushType.XIAOMI)) {
            MiPushClient.clearNotification((Context)context);
        }
        RongNotificationInterface.removeAllNotification(context);
    }

    public static PushType getCurrentPushType(Context context) {
        if (PushCacheHelper.getInstance().isConfigDone(context)) {
            return PushCacheHelper.getInstance().getConfigPushType(context);
        }
        return PushType.UNKNOWN;
    }

    public static void clearAllPushNotifications(Context context) {
        RLog.i(TAG, "clearAllPushNotifications");
        if (PushCacheHelper.getInstance().getConfigPushType(context).equals((Object)PushType.XIAOMI)) {
            MiPushClient.clearNotification((Context)context);
        }
        RongNotificationInterface.removeAllPushNotification(context);
    }

    public static void clearAllPushServiceNotifications(Context context) {
        if (PushCacheHelper.getInstance().getConfigPushType(context).equals((Object)PushType.XIAOMI)) {
            MiPushClient.clearNotification((Context)context);
        }
        RongNotificationInterface.removeAllPushServiceNotification(context);
    }

    public static void clearNotificationById(Context context, int notificationId) {
        if (PushCacheHelper.getInstance().getConfigPushType(context).equals((Object)PushType.XIAOMI)) {
            MiPushClient.clearNotification((Context)context, (int)notificationId);
        }
        RongNotificationInterface.removeNotification(context, notificationId);
    }

    @Deprecated
    public static void recordNotificationEvent(String pushId) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (pushId == null || pushId.equals("")) {
            RLog.e(TAG, "pushId can't be null!");
            return;
        }
        if (!Statistics.sharedInstance().isInitialized()) {
            RLog.e(TAG, "Statistics should be initialized firstly!");
            return;
        }
        RLog.i(TAG, "recordNotificationEvent");
        map.put("id", pushId);
        Statistics.sharedInstance().recordEvent("pushEvent", map);
    }

    public static void recordNotificationEvent(PushNotificationMessage pushNotificationMessage) {
        RongPushClient.recordNotificationEvent(pushNotificationMessage.getPushId(), pushNotificationMessage.getToId(), pushNotificationMessage.getObjectName(), pushNotificationMessage.getSourceType());
    }

    private static void recordNotificationEvent(String pushId, String userId, String objName, PushNotificationMessage.PushSourceType type) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (!Statistics.sharedInstance().isInitialized()) {
            RLog.e(TAG, "Statistics should be initialized firstly!");
            return;
        }
        RLog.i(TAG, "recordNotificationEvent");
        map.put("id", pushId);
        map.put("osName", "Android");
        String os = String.format("%s|%s", Build.MANUFACTURER, Build.MODEL);
        map.put("osVersion", os);
        map.put("sdkVersion", "4.1.0");
        if (TextUtils.isEmpty((CharSequence)objName)) {
            objName = "unKnow";
        }
        map.put("objectName", objName);
        if (TextUtils.isEmpty((CharSequence)userId)) {
            userId = "push_targetId";
        }
        map.put("userId", userId);
        map.put("sourceType", Integer.toString(type.ordinal()));
        Statistics.sharedInstance().recordEvent("pushEvent", map);
    }

    public static void recordHWNotificationEvent(Intent intent) {
        if (intent == null) {
            return;
        }
        String options = intent.getStringExtra("options");
        if (!TextUtils.isEmpty((CharSequence)options)) {
            try {
                JSONObject jsonObject = new JSONObject(options);
                if (jsonObject.has("rc")) {
                    JSONObject rc = jsonObject.getJSONObject("rc");
                    String pushId = rc.optString("id");
                    if (TextUtils.isEmpty((CharSequence)pushId)) {
                        RLog.d(TAG, "pushId is empty,recordNotificationEvent is failure");
                        return;
                    }
                    String objectName = rc.optString("objectName");
                    String userId = rc.optString("tId");
                    String type = rc.optString("sourceType");
                    PushNotificationMessage.PushSourceType sourceType = PushNotificationMessage.PushSourceType.FROM_ADMIN;
                    if (!TextUtils.isEmpty((CharSequence)type)) {
                        sourceType = PushNotificationMessage.PushSourceType.values()[Integer.parseInt(type)];
                    }
                    RongPushClient.recordNotificationEvent(pushId, userId, objectName, sourceType);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @Deprecated
    public static void stopRongPush(Context context) {
        Intent intent = new Intent(context, PushService.class);
        intent.setAction("io.rong.push.intent.action.STOP_PUSH");
        PushService.enqueueWork(context, intent);
    }

    public static void sendNotification(Context context, PushNotificationMessage notificationMessage) {
        String packageName = context.getPackageName();
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            RLog.e(TAG, "package name can't empty!");
            return;
        }
        if (null == notificationMessage) {
            RLog.e(TAG, "notificationMessage  can't be  null!");
            return;
        }
        Intent intent = new Intent();
        intent.setAction("io.rong.push.intent.MESSAGE_ARRIVED");
        intent.setPackage(packageName);
        intent.putExtra("pushType", PushType.RONG.getName());
        intent.putExtra("message", (Parcelable)notificationMessage);
        if (Build.VERSION.SDK_INT >= 12) {
            intent.setFlags(32);
        }
        context.sendBroadcast(intent);
    }

    public static void sendNotification(Context context, PushNotificationMessage notificationMessage, int left) {
        String packageName = context.getPackageName();
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            RLog.e(TAG, "package name can't empty!");
            return;
        }
        if (null == notificationMessage) {
            RLog.e(TAG, "notificationMessage  can't be  null!");
            return;
        }
        Intent intent = new Intent();
        intent.setAction("io.rong.push.intent.MESSAGE_ARRIVED");
        intent.setPackage(packageName);
        intent.putExtra("pushType", PushType.RONG.getName());
        intent.putExtra("message", (Parcelable)notificationMessage);
        intent.putExtra("left", left);
        if (Build.VERSION.SDK_INT >= 12) {
            intent.setFlags(32);
        }
        context.sendBroadcast(intent);
    }

    public static void setNotifiationSound(Uri uri) {
        RongNotificationInterface.setNotificationSound(uri);
    }

    @Deprecated
    public static void checkManifest(Context context) {
    }

    public static void cancelPushHeartBeat(Context context) {
        Intent intent = new Intent(context, PushService.class);
        intent.setAction("io.rong.push.intent.action.CANCEL_HEART_BEAT");
        PushService.enqueueWork(context, intent);
    }

    public static void sendPushPing(Context context) {
        Intent intent = new Intent(context, PushService.class);
        intent.setAction("io.rong.push.intent.action.CUSTOM_HEART_BEAT");
        PushService.enqueueWork(context, intent);
    }

    public static void updatePushContentShowStatus(Context context, boolean isShow) {
        if (PushCacheHelper.getInstance().getPushContentShowStatus(context) ^ isShow) {
            PushCacheHelper.getInstance().setPushContentShowStatus(context, isShow);
        }
    }

    public static enum ConversationType {
        NONE(0, "none"),
        PRIVATE(1, "private"),
        DISCUSSION(2, "discussion"),
        GROUP(3, "group"),
        CHATROOM(4, "chatroom"),
        CUSTOMER_SERVICE(5, "customer_service"),
        SYSTEM(6, "system"),
        APP_PUBLIC_SERVICE(7, "app_public_service"),
        PUBLIC_SERVICE(8, "public_service"),
        PUSH_SERVICE(9, "push_service"),
        ENCRYPTED(11, "encrypted");

        private int value = 1;
        private String name = "";

        private ConversationType(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public static ConversationType setValue(int code) {
            for (ConversationType c : ConversationType.values()) {
                if (code != c.getValue()) continue;
                return c;
            }
            return PRIVATE;
        }
    }
}

