/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.os.Parcel;
import android.os.Parcelable;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MessageContent;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:SRSMsg", flag=0)
public class SyncReadStatusMessage
extends MessageContent {
    private static final String TAG = "SyncReadStatusMessage";
    private long lastMessageSendTime;
    public static final Parcelable.Creator<SyncReadStatusMessage> CREATOR = new Parcelable.Creator<SyncReadStatusMessage>(){

        public SyncReadStatusMessage createFromParcel(Parcel source) {
            return new SyncReadStatusMessage(source);
        }

        public SyncReadStatusMessage[] newArray(int size) {
            return new SyncReadStatusMessage[size];
        }
    };

    public long getLastMessageSendTime() {
        return this.lastMessageSendTime;
    }

    public SyncReadStatusMessage(long lastMessageSendTime) {
        this.lastMessageSendTime = lastMessageSendTime;
    }

    public SyncReadStatusMessage(Parcel in) {
        this.lastMessageSendTime = ParcelUtils.readLongFromParcel(in);
    }

    public SyncReadStatusMessage(byte[] data) {
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e(TAG, e.getMessage());
        }
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            if (jsonObj.has("lastMessageSendTime")) {
                this.lastMessageSendTime = jsonObj.getLong("lastMessageSendTime");
            }
        }
        catch (JSONException e) {
            RLog.e(TAG, e.getMessage());
        }
    }

    @Override
    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("lastMessageSendTime", this.lastMessageSendTime);
        }
        catch (JSONException e) {
            RLog.e(TAG, "JSONException " + e.getMessage());
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e(TAG, "UnsupportedEncodingException ", e);
            return null;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel(dest, this.lastMessageSendTime);
    }
}

