/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MentionedInfo;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.UserInfo;
import io.rong.message.FileMessage;
import io.rong.message.ImageMessage;
import io.rong.message.MediaMessageContent;
import io.rong.message.ReferenceMessageHandler;
import io.rong.message.RichContentMessage;
import io.rong.message.TextMessage;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:ReferenceMsg", flag=3, messageHandler=ReferenceMessageHandler.class)
public class ReferenceMessage
extends MediaMessageContent {
    private static final String TAG = "ReferenceMessage";
    private String content;
    private String referMsgUserId;
    private String objName;
    private MessageContent referMsg;
    private String extra;
    public static final Parcelable.Creator<ReferenceMessage> CREATOR = new Parcelable.Creator<ReferenceMessage>(){

        public ReferenceMessage createFromParcel(Parcel in) {
            return new ReferenceMessage(in);
        }

        public ReferenceMessage[] newArray(int size) {
            return new ReferenceMessage[size];
        }
    };

    private ReferenceMessage() {
    }

    private ReferenceMessage(String userId, MessageContent referMsg) {
        this.referMsgUserId = userId;
        this.referMsg = referMsg;
        if (referMsg == null) {
            RLog.e(TAG, "MessageContent is null");
            return;
        }
        MessageTag msgTag = null;
        try {
            msgTag = referMsg.getClass().getAnnotation(MessageTag.class);
        }
        catch (Throwable throwable) {
            RLog.e(TAG, "throwable:" + throwable.toString());
        }
        if (msgTag == null) {
            RLog.e(TAG, "MessageTag is null");
            return;
        }
        String[] referenceSupportMsgType = new String[]{"RC:TxtMsg", "RC:ImgMsg", "RC:FileMsg", "RC:ImgTextMsg", "RC:ReferenceMsg"};
        boolean isContains = Arrays.asList(referenceSupportMsgType).contains(msgTag.value());
        if (!isContains) {
            throw new RuntimeException("\u5f15\u7528\u6d88\u606f\u4e0d\u652f\u6301\u6b64\u6d88\u606f\u7c7b\u578b");
        }
        this.objName = msgTag.value();
    }

    public static ReferenceMessage obtainMessage(String userId, MessageContent referMsg) {
        if (userId == null || referMsg == null) {
            return null;
        }
        return new ReferenceMessage(userId, referMsg);
    }

    @Override
    public byte[] encode() {
        JSONObject jsonObject = new JSONObject();
        try {
            if (!TextUtils.isEmpty((CharSequence)this.getUserId())) {
                jsonObject.put("referMsgUserId", (Object)this.getUserId());
            }
            if (!TextUtils.isEmpty((CharSequence)this.getEditSendText())) {
                jsonObject.put("content", (Object)this.getEditSendText());
            }
            if (!TextUtils.isEmpty((CharSequence)this.getObjName())) {
                jsonObject.put("objName", (Object)this.getObjName());
            }
            if (this.getReferenceContent() != null) {
                byte[] encode = this.getReferenceContent().encode();
                String string2 = new String(encode, "UTF-8");
                JSONObject jsonObject1 = new JSONObject(string2);
                jsonObject.putOpt("referMsg", (Object)jsonObject1);
            }
            if (!TextUtils.isEmpty((CharSequence)this.getExtra())) {
                jsonObject.put("extra", (Object)this.getExtra());
            }
            if (this.getJSONUserInfo() != null) {
                jsonObject.putOpt("user", (Object)this.getJSONUserInfo());
            }
            if (this.getJsonMentionInfo() != null) {
                jsonObject.putOpt("mentionedInfo", (Object)this.getJsonMentionInfo());
            }
        }
        catch (JSONException e) {
            RLog.e(TAG, "encode JSONException", e);
        }
        catch (UnsupportedEncodingException e) {
            RLog.e(TAG, "encode UnsupportedEncodingException", e);
        }
        try {
            return jsonObject.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e(TAG, "encode jsonObject UnsupportedEncodingException", e);
            return null;
        }
    }

    public ReferenceMessage(byte[] data) {
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e(TAG, "UnsupportedEncodingException", e);
        }
        if (jsonStr == null) {
            RLog.e(TAG, "jsonStr is null");
            return;
        }
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            if (jsonObj.has("referMsgUserId")) {
                this.setUserId(jsonObj.getString("referMsgUserId"));
            }
            if (jsonObj.has("content")) {
                this.setEditSendText(jsonObj.getString("content"));
            }
            if (jsonObj.has("objName")) {
                this.setObjName(jsonObj.getString("objName"));
            }
            if (jsonObj.has("referMsg") && !TextUtils.isEmpty((CharSequence)this.getObjName())) {
                JSONObject jsonObject = (JSONObject)jsonObj.get("referMsg");
                byte[] bytes = jsonObject.toString().getBytes("UTF-8");
                switch (this.getObjName()) {
                    case "RC:TxtMsg": {
                        TextMessage textMessage = new TextMessage(bytes);
                        this.setContent(textMessage);
                        break;
                    }
                    case "RC:ImgMsg": {
                        ImageMessage imageMessage = new ImageMessage(bytes);
                        this.setContent(imageMessage);
                        break;
                    }
                    case "RC:FileMsg": {
                        FileMessage fileMessage = new FileMessage(bytes);
                        this.setContent(fileMessage);
                        break;
                    }
                    case "RC:ImgTextMsg": {
                        RichContentMessage richContentMessage = new RichContentMessage(bytes);
                        this.setContent(richContentMessage);
                        break;
                    }
                    case "RC:ReferenceMsg": {
                        ReferenceMessage referenceMessage = new ReferenceMessage(bytes);
                        this.setContent(referenceMessage);
                    }
                }
            }
            if (jsonObj.has("extra")) {
                this.setExtra(jsonObj.getString("extra"));
            }
            if (jsonObj.has("user")) {
                this.setUserInfo(this.parseJsonToUserInfo(jsonObj.getJSONObject("user")));
            }
            if (jsonObj.has("mentionedInfo")) {
                this.setMentionedInfo(this.parseJsonToMentionInfo(jsonObj.getJSONObject("mentionedInfo")));
            }
        }
        catch (JSONException e) {
            RLog.e(TAG, "JSONException " + e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            RLog.e(TAG, "ReferenceMessage UnsupportedEncodingException", e);
        }
    }

    public int describeContents() {
        return 0;
    }

    public ReferenceMessage(Parcel in) {
        this.setUserId(in.readString());
        this.setEditSendText(in.readString());
        this.setObjName(in.readString());
        this.setContent(ParcelUtils.readFromParcel(in, MessageContent.class));
        this.setExtra(in.readString());
        this.setUserInfo(ParcelUtils.readFromParcel(in, UserInfo.class));
        this.setMentionedInfo(ParcelUtils.readFromParcel(in, MentionedInfo.class));
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel(dest, this.getUserId());
        ParcelUtils.writeToParcel(dest, this.getEditSendText());
        ParcelUtils.writeToParcel(dest, this.getObjName());
        ParcelUtils.writeToParcel(dest, this.getReferenceContent());
        ParcelUtils.writeToParcel(dest, this.getExtra());
        ParcelUtils.writeToParcel(dest, this.getUserInfo());
        ParcelUtils.writeToParcel(dest, this.getMentionedInfo());
    }

    public MessageContent getReferenceContent() {
        return this.referMsg;
    }

    public void setContent(MessageContent referMsg) {
        this.referMsg = referMsg;
    }

    @Override
    public Uri getLocalPath() {
        if (this.objName.equals("RC:FileMsg")) {
            return ((FileMessage)this.referMsg).getLocalPath();
        }
        return null;
    }

    @Override
    public Uri getMediaUrl() {
        if (this.objName.equals("RC:FileMsg")) {
            return ((FileMessage)this.referMsg).getMediaUrl();
        }
        return null;
    }

    @Override
    public void setMediaUrl(Uri mMediaUrl) {
        if (this.objName.equals("RC:FileMsg")) {
            ((FileMessage)this.referMsg).setMediaUrl(mMediaUrl);
        }
    }

    @Override
    public void setLocalPath(Uri mLocalPath) {
        if (this.objName.equals("RC:FileMsg")) {
            ((FileMessage)this.referMsg).setLocalPath(mLocalPath);
        }
    }

    @Override
    public String getExtra() {
        return this.extra;
    }

    @Override
    public void setExtra(String extra) {
        this.extra = extra;
    }

    @Override
    public String getName() {
        if (this.objName.equals("RC:FileMsg")) {
            return ((FileMessage)this.referMsg).getName();
        }
        return null;
    }

    @Override
    public void setName(String name) {
        if (this.objName.equals("RC:FileMsg")) {
            ((FileMessage)this.referMsg).setName(name);
        }
    }

    public String getEditSendText() {
        return this.content;
    }

    public void setEditSendText(String referenceContent) {
        this.content = referenceContent;
    }

    String getObjName() {
        return this.objName;
    }

    void setObjName(String objName) {
        this.objName = objName;
    }

    public ReferenceMessage buildSendText(String content) {
        this.content = content;
        return this;
    }

    public String getUserId() {
        return this.referMsgUserId;
    }

    public void setUserId(String userId) {
        this.referMsgUserId = userId;
    }

    @Override
    public List<String> getSearchableWord() {
        ArrayList<String> words = new ArrayList<String>();
        words.add(this.getEditSendText());
        return words;
    }
}

