/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.os.Parcel;
import android.os.Parcelable;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageContent;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:RRRspMsg", flag=0)
public class ReadReceiptResponseMessage
extends MessageContent {
    private static final String TAG = "ReadReceiptResponseMessage";
    private static final String RECEIPT_MAP = "receiptMessageDic";
    private HashMap<String, ArrayList<String>> mReceiptMap;
    public static final Parcelable.Creator<ReadReceiptResponseMessage> CREATOR = new Parcelable.Creator<ReadReceiptResponseMessage>(){

        public ReadReceiptResponseMessage createFromParcel(Parcel source) {
            return new ReadReceiptResponseMessage(source);
        }

        public ReadReceiptResponseMessage[] newArray(int size) {
            return new ReadReceiptResponseMessage[size];
        }
    };

    public ReadReceiptResponseMessage(HashMap<String, ArrayList<String>> receiptMap) {
        this.mReceiptMap = receiptMap;
    }

    public ReadReceiptResponseMessage(List<Message> messageList) {
        this.mReceiptMap = new HashMap();
        for (Message message : messageList) {
            String userId = message.getSenderUserId();
            String messageUId = message.getUId();
            ArrayList<String> messageUIdList = this.mReceiptMap.get(userId);
            if (messageUIdList == null) {
                messageUIdList = new ArrayList();
            }
            if (messageUIdList.contains(messageUId)) continue;
            messageUIdList.add(messageUId);
            this.mReceiptMap.put(userId, messageUIdList);
        }
    }

    public Set<String> getSenderIdSet() {
        return this.mReceiptMap.keySet();
    }

    public ArrayList<String> getMessageUIdListBySenderId(String senderId) {
        return this.mReceiptMap.get(senderId);
    }

    public ReadReceiptResponseMessage(Parcel in) {
        this.mReceiptMap = (HashMap)ParcelUtils.readMapFromParcel(in);
    }

    public ReadReceiptResponseMessage(byte[] data) {
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e(TAG, e.getMessage());
        }
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            if (jsonObj.has(RECEIPT_MAP)) {
                this.mReceiptMap = new HashMap();
                JSONObject valueObj = jsonObj.getJSONObject(RECEIPT_MAP);
                Iterator it = valueObj.keys();
                while (it.hasNext()) {
                    String key = it.next().toString();
                    JSONArray jsonArray = valueObj.getJSONArray(key);
                    ArrayList<String> messageUIdList = new ArrayList<String>();
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        messageUIdList.add(jsonArray.getString(i));
                    }
                    this.mReceiptMap.put(key, messageUIdList);
                }
            }
        }
        catch (JSONException e) {
            RLog.e(TAG, e.getMessage());
        }
    }

    @Override
    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        JSONObject valueObj = new JSONObject();
        try {
            if (this.mReceiptMap != null) {
                for (String key : this.mReceiptMap.keySet()) {
                    ArrayList<String> messageUIdList = this.mReceiptMap.get(key);
                    JSONArray jsonArray = new JSONArray();
                    for (String uId : messageUIdList) {
                        jsonArray.put((Object)uId);
                    }
                    valueObj.put(key, (Object)jsonArray);
                }
                jsonObj.put(RECEIPT_MAP, (Object)valueObj);
            }
        }
        catch (JSONException e) {
            RLog.e(TAG, "JSONException " + e.getMessage());
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e(TAG, "UnsupportedEncodingException ", e);
            return null;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel(dest, this.mReceiptMap);
    }
}

