/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MessageContent;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:MsgExMsg", flag=0)
public class MessageExpansionMessage
extends MessageContent {
    private static final String TAG = "MessageExpansionMessage";
    private String originalMsgUId;
    private Map<String, String> updateExpansion;
    private List<String> removeExpansionKeyList;
    private boolean removeAllKeys;
    public static final Parcelable.Creator<MessageExpansionMessage> CREATOR = new Parcelable.Creator<MessageExpansionMessage>(){

        public MessageExpansionMessage createFromParcel(Parcel source) {
            return new MessageExpansionMessage(source);
        }

        public MessageExpansionMessage[] newArray(int size) {
            return new MessageExpansionMessage[size];
        }
    };

    private MessageExpansionMessage(String originalMsgUId, List<String> removeExpansionKeyList) {
        this.originalMsgUId = originalMsgUId;
        this.removeExpansionKeyList = removeExpansionKeyList;
    }

    private MessageExpansionMessage(String originalMsgUId, boolean removeAllKeys) {
        this.originalMsgUId = originalMsgUId;
        this.removeAllKeys = removeAllKeys;
    }

    private MessageExpansionMessage(String originalMsgUId, Map<String, String> updateExpansion) {
        this.originalMsgUId = originalMsgUId;
        this.updateExpansion = updateExpansion;
    }

    public String getOriginalMsgUId() {
        return this.originalMsgUId;
    }

    public void setOriginalMsgUId(String originalMsgUId) {
        this.originalMsgUId = originalMsgUId;
    }

    public Map<String, String> getUpdateExpansion() {
        return this.updateExpansion;
    }

    public void setUpdateExpansionDic(Map<String, String> updateExpansion) {
        this.updateExpansion = updateExpansion;
    }

    public List<String> getRemoveExpansionKeyList() {
        return this.removeExpansionKeyList;
    }

    public void setRemoveExpansionKeyList(List<String> removeExpansionKeyList) {
        this.removeExpansionKeyList = removeExpansionKeyList;
    }

    public boolean isRemoveAllKeys() {
        return this.removeAllKeys;
    }

    public void setRemoveAllKeys(boolean removeAllKeys) {
        this.removeAllKeys = removeAllKeys;
    }

    private MessageExpansionMessage(Parcel in) {
        this.setOriginalMsgUId(ParcelUtils.readFromParcel(in));
        this.setUpdateExpansionDic(ParcelUtils.readMapFromParcel(in));
        this.setRemoveExpansionKeyList(ParcelUtils.readListFromParcel(in, String.class));
        this.setRemoveAllKeys(ParcelUtils.readIntFromParcel(in) == 1);
    }

    public static MessageExpansionMessage obtain(String originalMsgUId, Map<String, String> updateExpansion) {
        if (TextUtils.isEmpty((CharSequence)originalMsgUId)) {
            throw new IllegalArgumentException("originalMsgUId is empty");
        }
        return new MessageExpansionMessage(originalMsgUId, updateExpansion);
    }

    public static MessageExpansionMessage obtain(String originalMsgUId, List<String> removeExpansionKeyList) {
        if (TextUtils.isEmpty((CharSequence)originalMsgUId)) {
            throw new IllegalArgumentException("originalMsgUId is empty");
        }
        return new MessageExpansionMessage(originalMsgUId, removeExpansionKeyList);
    }

    public static MessageExpansionMessage obtain(String originalMsgUId, boolean removeAllKeys) {
        if (TextUtils.isEmpty((CharSequence)originalMsgUId)) {
            throw new IllegalArgumentException("originalMsgUId is empty");
        }
        return new MessageExpansionMessage(originalMsgUId, removeAllKeys);
    }

    @Override
    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            if (!TextUtils.isEmpty((CharSequence)this.getOriginalMsgUId())) {
                jsonObj.put("mid", (Object)this.getOriginalMsgUId());
            }
            if (this.getUpdateExpansion() != null) {
                jsonObj.put("put", (Object)this.getExpansionDicJSON());
            }
            jsonObj.put("del", (Object)this.getRemoveExpansionKeyJSON());
            jsonObj.put("clear", this.isRemoveAllKeys() ? 1 : 0);
        }
        catch (JSONException e) {
            RLog.e(TAG, "JSONException " + e.getMessage());
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e(TAG, "UnsupportedEncodingException", e);
            return null;
        }
    }

    public MessageExpansionMessage(byte[] data) {
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e(TAG, e.getMessage());
        }
        if (TextUtils.isEmpty((CharSequence)jsonStr)) {
            RLog.e(TAG, "MessageExpansionMessage jsonStr is empty");
            return;
        }
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            if (jsonObj.has("mid")) {
                this.setOriginalMsgUId(jsonObj.optString("mid"));
            }
            if (jsonObj.has("put")) {
                this.resolveExpansionDic(jsonObj);
            }
            if (jsonObj.has("del")) {
                this.resolveExpansionKeyList(jsonObj);
            }
            if (jsonObj.has("clear")) {
                this.setRemoveAllKeys(jsonObj.optInt("clear") == 1);
            }
        }
        catch (JSONException e) {
            RLog.e(TAG, e.getMessage());
        }
    }

    private void resolveExpansionDic(JSONObject jsonObj) {
        try {
            JSONObject innerObject = new JSONObject(jsonObj.optString("put"));
            Iterator it = innerObject.keys();
            while (it.hasNext()) {
                String key = String.valueOf(it.next());
                String value = innerObject.optString(key);
                if (this.updateExpansion == null) {
                    this.updateExpansion = new HashMap<String, String>();
                }
                this.updateExpansion.put(key, value);
            }
        }
        catch (JSONException e) {
            RLog.e(TAG, e.getMessage());
        }
    }

    private void resolveExpansionKeyList(JSONObject jsonObj) throws JSONException {
        JSONArray array = jsonObj.getJSONArray("del");
        for (int i = 0; i < array.length(); ++i) {
            if (this.removeExpansionKeyList == null) {
                this.removeExpansionKeyList = new ArrayList<String>();
            }
            this.removeExpansionKeyList.add(array.getString(i));
        }
    }

    private JSONObject getExpansionDicJSON() {
        JSONObject jsonObj = new JSONObject();
        Iterator<String> it = this.updateExpansion.keySet().iterator();
        try {
            while (it.hasNext()) {
                String key = it.next();
                jsonObj.put(key, (Object)this.updateExpansion.get(key));
            }
        }
        catch (JSONException e) {
            return null;
        }
        return jsonObj;
    }

    private JSONArray getRemoveExpansionKeyJSON() {
        return new JSONArray(this.removeExpansionKeyList);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel(dest, this.originalMsgUId);
        ParcelUtils.writeToParcel(dest, this.updateExpansion);
        ParcelUtils.writeListToParcel(dest, this.removeExpansionKeyList);
        ParcelUtils.writeToParcel(dest, this.removeAllKeys ? 1 : 0);
    }
}

