/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MessageContent;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:LogCmdMsg", flag=0)
public class LogCmdMessage
extends MessageContent {
    private String uri;
    private String logId;
    private String platform;
    private String packageName;
    private long startTime;
    private long endTime;
    public static final Parcelable.Creator<LogCmdMessage> CREATOR = new Parcelable.Creator<LogCmdMessage>(){

        public LogCmdMessage createFromParcel(Parcel source) {
            return new LogCmdMessage(source);
        }

        public LogCmdMessage[] newArray(int size) {
            return new LogCmdMessage[size];
        }
    };

    public LogCmdMessage(byte[] data) {
        String jsonStr = new String(data);
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            this.uri = jsonObj.optString("uri");
            this.logId = jsonObj.optString("logId");
            this.platform = jsonObj.optString("platform");
            this.packageName = jsonObj.optString("packageName");
            this.startTime = jsonObj.optLong("startTime");
            this.endTime = jsonObj.optLong("endTime");
        }
        catch (JSONException e) {
            Log.e((String)"JSONException", (String)e.getMessage());
        }
    }

    public String getUri() {
        return this.uri;
    }

    public String getLogId() {
        return this.logId;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            String packageName;
            String platform;
            String logId;
            String uri = this.getUri();
            if (uri != null) {
                jsonObj.put("uri", (Object)uri);
            }
            if ((logId = this.getLogId()) != null) {
                jsonObj.put("logId", (Object)logId);
            }
            if ((platform = this.getPlatform()) != null) {
                jsonObj.put("platform", (Object)platform);
            }
            if ((packageName = this.getPackageName()) != null) {
                jsonObj.put("packageName", (Object)packageName);
            }
            long startTime = this.getStartTime();
            jsonObj.put("startTime", startTime);
            jsonObj.put("endTime", this.endTime);
        }
        catch (JSONException e) {
            RLog.e("JSONException", e.getMessage());
        }
        return jsonObj.toString().getBytes();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel(dest, this.getUri());
        ParcelUtils.writeToParcel(dest, this.getLogId());
        ParcelUtils.writeToParcel(dest, this.getPlatform());
        ParcelUtils.writeToParcel(dest, this.getPackageName());
        ParcelUtils.writeToParcel(dest, this.getStartTime());
        ParcelUtils.writeToParcel(dest, this.getEndTime());
    }

    public LogCmdMessage(Parcel in) {
        this.uri = ParcelUtils.readFromParcel(in);
        this.logId = ParcelUtils.readFromParcel(in);
        this.platform = ParcelUtils.readFromParcel(in);
        this.packageName = ParcelUtils.readFromParcel(in);
        this.startTime = ParcelUtils.readLongFromParcel(in);
        this.endTime = ParcelUtils.readLongFromParcel(in);
    }
}

