/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import io.rong.common.FileUtils;
import io.rong.common.RLog;
import io.rong.imlib.NativeClient;
import io.rong.imlib.common.NetUtils;
import io.rong.imlib.model.Message;
import io.rong.message.LocationMessage;
import io.rong.message.MessageHandler;
import io.rong.message.utils.BitmapUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class LocationMessageHandler
extends MessageHandler<LocationMessage> {
    private static final String TAG = "LocationMessageHandler";
    private static final int THUMB_WIDTH = 408;
    private static final int THUMB_HEIGHT = 240;
    private static final int THUMB_COMPRESSED_QUALITY = 30;

    public LocationMessageHandler(Context context) {
        super(context);
    }

    @Override
    public void decodeMessage(Message message, LocationMessage content) {
        String base64;
        Uri uri;
        File file;
        String name = message.getMessageId() + "";
        if (message.getMessageId() == 0) {
            name = message.getSentTime() + "";
        }
        if ((file = new File((uri = NativeClient.getInstance().obtainMediaFileSavedUri()).toString() + name)).exists()) {
            content.setImgUri(Uri.fromFile((File)file));
            return;
        }
        if (content != null && !TextUtils.isEmpty((CharSequence)(base64 = content.getBase64()))) {
            if (base64.startsWith("http")) {
                content.setImgUri(Uri.parse((String)base64));
                content.setBase64(null);
            } else {
                try {
                    byte[] audio = Base64.decode((String)content.getBase64(), (int)2);
                    file = FileUtils.byte2File(audio, uri.toString(), name + "");
                    if (content.getImgUri() == null) {
                        if (file != null && file.exists()) {
                            content.setImgUri(Uri.fromFile((File)file));
                        } else {
                            RLog.e(TAG, "getImgUri is null");
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    RLog.e(TAG, "Not Base64 Content!");
                    RLog.e(TAG, "IllegalArgumentException", e);
                }
                message.setContent(content);
                content.setBase64(null);
            }
        }
    }

    @Override
    public void encodeMessage(Message message) {
        block14: {
            File file;
            String thumbnailPath;
            LocationMessage content = (LocationMessage)message.getContent();
            if (content.getImgUri() == null) {
                RLog.w(TAG, "No thumbnail uri.");
                if (this.mHandleMessageListener != null) {
                    this.mHandleMessageListener.onHandleResult(message, 0);
                }
                return;
            }
            Uri uri = NativeClient.getInstance().obtainMediaFileSavedUri();
            String scheme = content.getImgUri().getScheme();
            if (!TextUtils.isEmpty((CharSequence)scheme) && scheme.toLowerCase().equals("file")) {
                thumbnailPath = content.getImgUri().getPath();
            } else {
                file = this.loadLocationThumbnail(content, message.getSentTime() + "");
                String string2 = thumbnailPath = file != null ? file.getPath() : null;
            }
            if (thumbnailPath == null) {
                RLog.e(TAG, "load thumbnailPath null!");
                if (this.mHandleMessageListener != null) {
                    this.mHandleMessageListener.onHandleResult(message, -1);
                }
                return;
            }
            try {
                Bitmap bitmap = BitmapUtil.interceptBitmap(thumbnailPath, 408, 240);
                if (bitmap != null) {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 30, (OutputStream)outputStream);
                    byte[] data = outputStream.toByteArray();
                    outputStream.close();
                    String base64 = Base64.encodeToString((byte[])data, (int)2);
                    content.setBase64(base64);
                    file = FileUtils.byte2File(data, uri.toString(), message.getMessageId() + "");
                    if (file != null && file.exists()) {
                        content.setImgUri(Uri.fromFile((File)file));
                    }
                    if (!bitmap.isRecycled()) {
                        bitmap.recycle();
                    }
                    if (this.mHandleMessageListener != null) {
                        this.mHandleMessageListener.onHandleResult(message, 0);
                    }
                } else {
                    RLog.e(TAG, "get null bitmap!");
                    if (this.mHandleMessageListener != null) {
                        this.mHandleMessageListener.onHandleResult(message, -1);
                    }
                }
            }
            catch (Exception e) {
                RLog.e(TAG, "Not Base64 Content!");
                RLog.e(TAG, "Exception ", e);
                if (this.mHandleMessageListener == null) break block14;
                this.mHandleMessageListener.onHandleResult(message, -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File loadLocationThumbnail(LocationMessage content, String name) {
        File file = null;
        HttpURLConnection conn = null;
        int responseCode = 0;
        try {
            Uri uri = content.getImgUri();
            URL url = new URL(uri.toString());
            conn = NetUtils.createURLConnection(url.toString());
            conn.setRequestMethod("GET");
            conn.setReadTimeout(3000);
            conn.connect();
            responseCode = conn.getResponseCode();
            if (responseCode >= 200 && responseCode < 300) {
                int len;
                boolean successMkdir;
                String path = FileUtils.getInternalCachePath(this.getContext(), "location");
                file = new File(path);
                if (!file.exists() && !(successMkdir = file.mkdirs())) {
                    RLog.e(TAG, "Created folders unSuccessfully");
                }
                file = new File(path, name);
                InputStream is = conn.getInputStream();
                FileOutputStream os = new FileOutputStream(file);
                byte[] buffer = new byte[1024];
                while ((len = is.read(buffer)) != -1) {
                    os.write(buffer, 0, len);
                }
                is.close();
                os.close();
            }
        }
        catch (Exception e) {
            RLog.e(TAG, "Exception ", e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
            RLog.d(TAG, "loadLocationThumbnail result : " + responseCode);
        }
        return file;
    }
}

