/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.os.Parcel;
import android.os.Parcelable;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.UserInfo;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:HDiv", flag=0)
public class HistoryDividerMessage
extends MessageContent {
    private static final String TAG = "NewMessageDivider";
    private String content;
    public static final Parcelable.Creator<HistoryDividerMessage> CREATOR = new Parcelable.Creator<HistoryDividerMessage>(){

        public HistoryDividerMessage createFromParcel(Parcel source) {
            return new HistoryDividerMessage(source);
        }

        public HistoryDividerMessage[] newArray(int size) {
            return new HistoryDividerMessage[size];
        }
    };

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public HistoryDividerMessage(Parcel in) {
        this.content = ParcelUtils.readFromParcel(in);
        this.setUserInfo(ParcelUtils.readFromParcel(in, UserInfo.class));
    }

    public static HistoryDividerMessage obtain(String content) {
        HistoryDividerMessage obj = new HistoryDividerMessage();
        obj.content = content;
        return obj;
    }

    private HistoryDividerMessage() {
    }

    @Override
    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("content", (Object)this.content);
            if (this.getJSONUserInfo() != null) {
                jsonObj.putOpt("user", (Object)this.getJSONUserInfo());
            }
        }
        catch (JSONException e) {
            RLog.e(TAG, "JSONException " + e.getMessage());
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e(TAG, "UnsupportedEncodingException", e);
            return null;
        }
    }

    public HistoryDividerMessage(byte[] data) {
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e(TAG, "UnsupportedEncodingException", e);
        }
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            this.setContent(jsonObj.optString("content"));
            if (jsonObj.has("user")) {
                this.setUserInfo(this.parseJsonToUserInfo(jsonObj.getJSONObject("user")));
            }
        }
        catch (JSONException e) {
            RLog.e(TAG, "JSONException " + e.getMessage());
        }
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel(dest, this.content);
        ParcelUtils.writeToParcel(dest, this.getUserInfo());
    }

    public int describeContents() {
        return 0;
    }
}

