/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.content.Context;
import android.net.Uri;
import io.rong.common.FileUtils;
import io.rong.common.RLog;
import io.rong.imlib.NativeClient;
import io.rong.imlib.model.Message;
import io.rong.message.HQVoiceMessage;
import io.rong.message.MessageHandler;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class HQVoiceMessageHandler
extends MessageHandler<HQVoiceMessage> {
    private static final String TAG = "HQVoiceMessageHandler";
    private static final String VOICE_PATH = "/hq_voice/";

    public HQVoiceMessageHandler(Context context) {
        super(context);
    }

    @Override
    public void decodeMessage(Message message, HQVoiceMessage content) {
    }

    @Override
    public void encodeMessage(Message message) {
        HQVoiceMessage model = (HQVoiceMessage)message.getContent();
        Uri uri = NativeClient.getInstance().obtainMediaFileSavedUri();
        byte[] voiceData = FileUtils.file2byte(this.getContext(), model.getLocalPath());
        File file = null;
        try {
            String name = message.getMessageId() + ".aac";
            file = HQVoiceMessageHandler.saveFile(voiceData, uri.toString() + VOICE_PATH, name);
        }
        catch (IOException e) {
            RLog.e(TAG, "IOException ", e);
        }
        if (file != null && file.exists()) {
            model.setLocalPath(Uri.fromFile((File)file));
            model.setName(file.getName());
        }
    }

    private static File saveFile(byte[] data, String path, String fileName) throws IOException {
        boolean successMkdir;
        File file = new File(path);
        if (!file.exists() && !(successMkdir = file.mkdirs())) {
            RLog.e(TAG, "Created folders unSuccessfully");
        }
        file = new File(path + fileName);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
        bos.write(data);
        bos.flush();
        bos.close();
        return file;
    }
}

