/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.os.Parcel;
import android.os.Parcelable;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MessageContent;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:CsEva", flag=0)
public class CSEvaluateMessage
extends MessageContent {
    private static final String TAG = "CSEvaluateMessage";
    private String uid;
    private String sid;
    private String pid;
    private int source;
    private String suggest;
    private int status = -1;
    private int type;
    private String tablets;
    private String extra;
    public static final Parcelable.Creator<CSEvaluateMessage> CREATOR = new Parcelable.Creator<CSEvaluateMessage>(){

        public CSEvaluateMessage createFromParcel(Parcel source) {
            return new CSEvaluateMessage(source);
        }

        public CSEvaluateMessage[] newArray(int size) {
            return new CSEvaluateMessage[size];
        }
    };

    private CSEvaluateMessage() {
    }

    public CSEvaluateMessage(byte[] data) {
    }

    public CSEvaluateMessage(Parcel in) {
        this.sid = ParcelUtils.readFromParcel(in);
        this.uid = ParcelUtils.readFromParcel(in);
        this.pid = ParcelUtils.readFromParcel(in);
        this.source = ParcelUtils.readIntFromParcel(in);
        this.suggest = ParcelUtils.readFromParcel(in);
        this.status = ParcelUtils.readIntFromParcel(in);
        this.type = ParcelUtils.readIntFromParcel(in);
        this.tablets = ParcelUtils.readFromParcel(in);
        this.extra = ParcelUtils.readFromParcel(in);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel(dest, this.sid);
        ParcelUtils.writeToParcel(dest, this.uid);
        ParcelUtils.writeToParcel(dest, this.pid);
        ParcelUtils.writeToParcel(dest, this.source);
        ParcelUtils.writeToParcel(dest, this.suggest);
        ParcelUtils.writeToParcel(dest, this.status);
        ParcelUtils.writeToParcel(dest, this.type);
        ParcelUtils.writeToParcel(dest, this.tablets);
        ParcelUtils.writeToParcel(dest, this.extra);
    }

    @Override
    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("uid", (Object)this.uid);
            jsonObj.put("sid", (Object)this.sid);
            jsonObj.put("pid", (Object)this.pid);
            jsonObj.put("source", this.source);
            jsonObj.put("suggest", (Object)this.suggest);
            jsonObj.put("isresolve", this.status);
            jsonObj.put("type", this.type);
            jsonObj.put("tag", (Object)this.tablets);
        }
        catch (JSONException e) {
            RLog.e(TAG, "JSONException " + e.getMessage());
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e(TAG, "UnsupportedEncodingException ", e);
            return null;
        }
    }

    public static class Builder {
        private String uid;
        private String sid;
        private String pid;
        private int source;
        private String suggest;
        private int solveStatus = -1;
        private int type;
        private String tablets;
        private String extra;

        public CSEvaluateMessage build() {
            CSEvaluateMessage message = new CSEvaluateMessage();
            message.sid = this.sid;
            message.pid = this.pid;
            message.uid = this.uid;
            message.source = this.source;
            message.suggest = this.suggest;
            message.status = this.solveStatus;
            message.type = this.type;
            message.tablets = this.tablets;
            message.extra = this.extra;
            return message;
        }

        public Builder sid(String sid) {
            this.sid = sid;
            return this;
        }

        public Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public Builder pid(String pid) {
            this.pid = pid;
            return this;
        }

        public Builder source(int source) {
            this.source = source;
            return this;
        }

        public Builder suggest(String suggest) {
            this.suggest = suggest;
            return this;
        }

        public Builder setSolveStatus(int status) {
            this.solveStatus = status;
            return this;
        }

        public Builder type(int type) {
            this.type = type;
            return this;
        }

        public Builder tablets(String tablets) {
            this.tablets = tablets;
            return this;
        }

        public Builder extra(String extra) {
            this.extra = extra;
            return this;
        }
    }
}

