/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.typingmessage;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.message.StatusMessage;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:TypSts", flag=16)
public class TypingStatusMessage
extends StatusMessage {
    private static final String TAG = "TypingStatusMessage";
    private String typingContentType;
    private String data;
    public static final Parcelable.Creator<TypingStatusMessage> CREATOR = new Parcelable.Creator<TypingStatusMessage>(){

        public TypingStatusMessage createFromParcel(Parcel source) {
            return new TypingStatusMessage(source);
        }

        public TypingStatusMessage[] newArray(int size) {
            return new TypingStatusMessage[size];
        }
    };

    public String getTypingContentType() {
        return this.typingContentType;
    }

    public void setTypingContentType(String typingContentType) {
        this.typingContentType = typingContentType;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public TypingStatusMessage(String type, String data) {
        this.setTypingContentType(type);
        this.setData(data);
    }

    public TypingStatusMessage(byte[] data) {
        String jsonStr = null;
        if (data == null || data.length == 0) {
            return;
        }
        try {
            jsonStr = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e(TAG, "TypingStatusMessage " + e.getMessage());
        }
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            if (jsonObj.has("typingContentType")) {
                this.setTypingContentType(jsonObj.getString("typingContentType"));
            }
            if (jsonObj.has("data")) {
                this.setData(jsonObj.getString("data"));
            }
        }
        catch (JSONException e) {
            RLog.e(TAG, "TypingStatusMessage " + e.getMessage());
        }
    }

    public TypingStatusMessage(Parcel in) {
        this.setTypingContentType(ParcelUtils.readFromParcel(in));
        this.setData(ParcelUtils.readFromParcel(in));
    }

    public TypingStatusMessage() {
    }

    @Override
    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("typingContentType", (Object)this.getTypingContentType());
            if (!TextUtils.isEmpty((CharSequence)this.getData())) {
                jsonObj.put("data", (Object)this.getData());
            }
        }
        catch (JSONException e) {
            RLog.e(TAG, "JSONException " + e.getMessage());
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e(TAG, "encode", e);
            return new byte[0];
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel(dest, this.getTypingContentType());
        ParcelUtils.writeToParcel(dest, this.getData());
    }
}

