/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.statistics;

import android.content.Context;
import android.util.Log;
import io.rong.imlib.statistics.AdvertisingIdAdapter;
import io.rong.imlib.statistics.ConnectionQueue;
import io.rong.imlib.statistics.CrashDetails;
import io.rong.imlib.statistics.DeviceId;
import io.rong.imlib.statistics.DeviceInfo;
import io.rong.imlib.statistics.EventQueue;
import io.rong.imlib.statistics.MessagingAdapter;
import io.rong.imlib.statistics.OpenUDIDAdapter;
import io.rong.imlib.statistics.ReferrerReceiver;
import io.rong.imlib.statistics.StatisticsStore;
import io.rong.imlib.statistics.UserData;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.json.JSONObject;

public class Statistics {
    public static final String COUNTLY_SDK_VERSION_STRING = "15.06";
    public static final String DEFAULT_APP_VERSION = "1.0";
    public static final String TAG = "Statistics";
    private static final int EVENT_QUEUE_SIZE_THRESHOLD = 10;
    protected static List<String> publicKeyPinCertificates;
    private ConnectionQueue connectionQueue_ = new ConnectionQueue();
    private ScheduledExecutorService timerService_;
    private EventQueue eventQueue_;
    private DeviceId deviceId_Manager_;
    private long prevSessionDurationStartTime_;
    private int activityCount_;
    private boolean disableUpdateSessionRequests_;
    private boolean enableLogging_;
    private CountlyMessagingMode messagingMode_;
    private Context context_;

    public static Statistics sharedInstance() {
        return SingletonHolder.instance;
    }

    Statistics() {
    }

    public Statistics init(Context context, String serverURL, String appKey) {
        return this.init(context, serverURL, appKey, null, OpenUDIDAdapter.isOpenUDIDAvailable() ? DeviceId.Type.OPEN_UDID : DeviceId.Type.ADVERTISING_ID);
    }

    public Statistics init(Context context, String serverURL, String appKey, String deviceID) {
        return this.init(context, serverURL, appKey, deviceID, null);
    }

    public synchronized Statistics init(Context context, String serverURL, String appKey, String deviceID, DeviceId.Type idMode) {
        if (context == null) {
            throw new IllegalArgumentException("valid context is required");
        }
        if (!Statistics.isValidURL(serverURL)) {
            throw new IllegalArgumentException("valid serverURL is required");
        }
        if (appKey == null || appKey.length() == 0) {
            throw new IllegalArgumentException("valid appKey is required");
        }
        if (deviceID != null && deviceID.length() == 0) {
            throw new IllegalArgumentException("valid deviceID is required");
        }
        if (deviceID == null && idMode == null) {
            if (OpenUDIDAdapter.isOpenUDIDAvailable()) {
                idMode = DeviceId.Type.OPEN_UDID;
            } else if (AdvertisingIdAdapter.isAdvertisingIdAvailable()) {
                idMode = DeviceId.Type.ADVERTISING_ID;
            }
        }
        if (deviceID == null && idMode == DeviceId.Type.OPEN_UDID && !OpenUDIDAdapter.isOpenUDIDAvailable()) {
            throw new IllegalArgumentException("valid deviceID is required because OpenUDID is not available");
        }
        if (deviceID == null && idMode == DeviceId.Type.ADVERTISING_ID && !AdvertisingIdAdapter.isAdvertisingIdAvailable()) {
            throw new IllegalArgumentException("valid deviceID is required because Advertising ID is not available (you need to include Google Play services 4.0+ into your project)");
        }
        if (!(this.eventQueue_ == null || this.connectionQueue_.getServerURL().equals(serverURL) && this.connectionQueue_.getAppKey().equals(appKey) && DeviceId.deviceIDEqualsNullSafe(deviceID, idMode, this.connectionQueue_.getDeviceId()))) {
            throw new IllegalStateException("Statistics cannot be reinitialized with different values");
        }
        if (MessagingAdapter.isMessagingAvailable()) {
            MessagingAdapter.storeConfiguration(context, serverURL, appKey, deviceID, idMode);
        }
        if (this.eventQueue_ == null) {
            DeviceId deviceIdInstance = deviceID != null ? new DeviceId(deviceID) : new DeviceId(idMode);
            StatisticsStore statisticsStore = new StatisticsStore(context);
            deviceIdInstance.init(context, statisticsStore, true);
            this.connectionQueue_.setServerURL(serverURL);
            this.connectionQueue_.setAppKey(appKey);
            this.connectionQueue_.setCountlyStore(statisticsStore);
            this.connectionQueue_.setDeviceId(deviceIdInstance);
            this.eventQueue_ = new EventQueue(statisticsStore);
        }
        this.context_ = context;
        this.connectionQueue_.setContext(context);
        return this;
    }

    public synchronized boolean isInitialized() {
        return this.eventQueue_ != null;
    }

    public synchronized void halt() {
        this.eventQueue_ = null;
        StatisticsStore statisticsStore = this.connectionQueue_.getCountlyStore();
        if (statisticsStore != null) {
            statisticsStore.clear();
        }
        this.connectionQueue_.setContext(null);
        this.connectionQueue_.setServerURL(null);
        this.connectionQueue_.setAppKey(null);
        this.connectionQueue_.setCountlyStore(null);
        this.prevSessionDurationStartTime_ = 0L;
        this.activityCount_ = 0;
    }

    public synchronized void onStart() {
        if (this.eventQueue_ == null) {
            throw new IllegalStateException("init must be called before onStart");
        }
        ++this.activityCount_;
        if (this.activityCount_ == 1) {
            Log.i((String)TAG, (String)"start");
            this.onStartHelper();
        }
        String referrer = ReferrerReceiver.getReferrer(this.context_);
        if (Statistics.sharedInstance().isLoggingEnabled()) {
            Log.d((String)TAG, (String)("Checking referrer: " + referrer));
        }
        if (referrer != null) {
            this.connectionQueue_.sendReferrerData(referrer);
            ReferrerReceiver.deleteReferrer(this.context_);
        }
        CrashDetails.inForeground();
    }

    void onStartHelper() {
        this.prevSessionDurationStartTime_ = System.nanoTime();
        this.connectionQueue_.beginSession();
    }

    public synchronized void onStop() {
        if (this.eventQueue_ == null) {
            throw new IllegalStateException("init must be called before onStop");
        }
        if (this.activityCount_ == 0) {
            throw new IllegalStateException("must call onStart before onStop");
        }
        --this.activityCount_;
        if (this.activityCount_ == 0) {
            this.onStopHelper();
        }
        CrashDetails.inBackground();
    }

    void onStopHelper() {
        this.connectionQueue_.endSession(this.roundedSecondsSinceLastSessionDurationUpdate());
        this.prevSessionDurationStartTime_ = 0L;
        if (this.eventQueue_.size() > 0) {
            this.connectionQueue_.recordEvents(this.eventQueue_.events());
        }
    }

    public void onRegistrationId(String registrationId) {
        this.connectionQueue_.tokenSession(registrationId, this.messagingMode_);
    }

    public void recordEvent(String key) {
        this.recordEvent(key, null, 1, 0.0);
    }

    public void recordEvent(String key, int count) {
        this.recordEvent(key, null, count, 0.0);
    }

    public void recordEvent(String key, int count, double sum) {
        this.recordEvent(key, null, count, sum);
    }

    public void recordEvent(String key, Map<String, String> segmentation, int count) {
        this.recordEvent(key, segmentation, count, 0.0);
    }

    public synchronized void recordEvent(String key, Map<String, String> segmentation, int count, double sum) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Statistics.sharedInstance().init must be called before recordEvent");
        }
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException("Valid Statistics event key is required");
        }
        if (count < 1) {
            throw new IllegalArgumentException("Statistics event count should be greater than zero");
        }
        if (segmentation != null) {
            for (String k : segmentation.keySet()) {
                if (k == null || k.length() == 0) {
                    throw new IllegalArgumentException("Statistics event segmentation key cannot be null or empty");
                }
                if (segmentation.get(k) != null && segmentation.get(k).length() != 0) continue;
                throw new IllegalArgumentException("Statistics event segmentation value cannot be null or empty");
            }
        }
        this.eventQueue_.recordEvent(key, segmentation, count, sum);
        this.sendEventsIfNeeded();
    }

    public synchronized void recordEvent(String key, Map<String, String> segmentation) {
        String[] data = new String[segmentation.size() * 2];
        int i = 0;
        if (!this.isInitialized()) {
            throw new IllegalStateException("Countly.sharedInstance().init must be called before recordEvent");
        }
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException("Valid Countly event key is required");
        }
        if (segmentation != null) {
            for (String k : segmentation.keySet()) {
                if (k == null || k.length() == 0) {
                    throw new IllegalArgumentException("Countly event segmentation key cannot be null or empty");
                }
                if (segmentation.get(k) == null || segmentation.get(k).length() == 0) {
                    throw new IllegalArgumentException("Countly event segmentation value cannot be null or empty");
                }
                data[i] = k;
                data[++i] = segmentation.get(k);
                ++i;
            }
        }
        JSONObject json = new JSONObject();
        DeviceInfo.fillJSONIfValuesNotEmpty(json, data);
        String result = json.toString();
        try {
            result = URLEncoder.encode(result, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.connectionQueue_.recordEvents(key, result);
    }

    public synchronized Statistics setUserData(Map<String, String> data) {
        return this.setUserData(data, null);
    }

    public synchronized Statistics setUserData(Map<String, String> data, Map<String, String> customdata) {
        UserData.setData(data);
        if (customdata != null) {
            UserData.setCustomData(customdata);
        }
        this.connectionQueue_.sendUserData();
        return this;
    }

    public synchronized Statistics setCustomUserData(Map<String, String> customdata) {
        if (customdata != null) {
            UserData.setCustomData(customdata);
        }
        this.connectionQueue_.sendUserData();
        return this;
    }

    public synchronized Statistics setLocation(double lat, double lon) {
        this.connectionQueue_.getCountlyStore().setLocation(lat, lon);
        if (this.disableUpdateSessionRequests_) {
            this.connectionQueue_.updateSession(this.roundedSecondsSinceLastSessionDurationUpdate());
        }
        return this;
    }

    public synchronized Statistics setCustomCrashSegments(Map<String, String> segments) {
        if (segments != null) {
            CrashDetails.setCustomSegments(segments);
        }
        return this;
    }

    public synchronized Statistics addCrashLog(String record) {
        CrashDetails.addLog(record);
        return this;
    }

    public synchronized Statistics logException(Exception exception) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exception.printStackTrace(pw);
        this.connectionQueue_.sendCrashReport(sw.toString(), true);
        return this;
    }

    public synchronized Statistics enableCrashReporting() {
        final Thread.UncaughtExceptionHandler oldHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.UncaughtExceptionHandler handler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                Statistics.this.connectionQueue_.sendCrashReport(sw.toString(), false);
                if (oldHandler != null) {
                    oldHandler.uncaughtException(t, e);
                }
            }
        };
        Thread.setDefaultUncaughtExceptionHandler(handler);
        return this;
    }

    public synchronized Statistics setDisableUpdateSessionRequests(boolean disable) {
        this.disableUpdateSessionRequests_ = disable;
        return this;
    }

    public synchronized Statistics setLoggingEnabled(boolean enableLogging) {
        this.enableLogging_ = enableLogging;
        return this;
    }

    public synchronized boolean isLoggingEnabled() {
        return this.enableLogging_;
    }

    void sendEventsIfNeeded() {
        Log.d((String)TAG, (String)("sendEventsIfNeeded: queue=" + this.eventQueue_.size()));
        if (this.eventQueue_.size() >= 10) {
            this.connectionQueue_.recordEvents(this.eventQueue_.events());
        }
    }

    synchronized void onTimer() {
        boolean hasActiveSession;
        boolean bl = hasActiveSession = this.activityCount_ > 0;
        if (hasActiveSession) {
            Log.d((String)TAG, (String)("onTimer: update=" + !this.disableUpdateSessionRequests_ + ", queue=" + this.eventQueue_.size()));
            if (!this.disableUpdateSessionRequests_) {
                this.connectionQueue_.updateSession(this.roundedSecondsSinceLastSessionDurationUpdate());
            }
            if (this.eventQueue_.size() > 0) {
                this.connectionQueue_.recordEvents(this.eventQueue_.events());
            }
        }
    }

    int roundedSecondsSinceLastSessionDurationUpdate() {
        long currentTimestampInNanoseconds = System.nanoTime();
        long unsentSessionLengthInNanoseconds = currentTimestampInNanoseconds - this.prevSessionDurationStartTime_;
        this.prevSessionDurationStartTime_ = currentTimestampInNanoseconds;
        return (int)Math.round((double)unsentSessionLengthInNanoseconds / 1.0E9);
    }

    static int currentTimestamp() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    static boolean isValidURL(String urlStr) {
        boolean validURL = false;
        if (urlStr != null && urlStr.length() > 0) {
            try {
                new URL(urlStr);
                validURL = true;
            }
            catch (MalformedURLException e) {
                validURL = false;
            }
        }
        return validURL;
    }

    public static Statistics enablePublicKeyPinning(List<String> certificates) {
        publicKeyPinCertificates = certificates;
        return Statistics.sharedInstance();
    }

    ConnectionQueue getConnectionQueue() {
        return this.connectionQueue_;
    }

    void setConnectionQueue(ConnectionQueue connectionQueue) {
        this.connectionQueue_ = connectionQueue;
    }

    ExecutorService getTimerService() {
        return this.timerService_;
    }

    EventQueue getEventQueue() {
        return this.eventQueue_;
    }

    void setEventQueue(EventQueue eventQueue) {
        this.eventQueue_ = eventQueue;
    }

    long getPrevSessionDurationStartTime() {
        return this.prevSessionDurationStartTime_;
    }

    void setPrevSessionDurationStartTime(long prevSessionDurationStartTime) {
        this.prevSessionDurationStartTime_ = prevSessionDurationStartTime;
    }

    int getActivityCount() {
        return this.activityCount_;
    }

    boolean getDisableUpdateSessionRequests() {
        return this.disableUpdateSessionRequests_;
    }

    private static class SingletonHolder {
        static final Statistics instance = new Statistics();

        private SingletonHolder() {
        }
    }

    public static enum CountlyMessagingMode {
        TEST,
        PRODUCTION;

    }
}

