/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.statistics;

import io.rong.imlib.statistics.Event;
import io.rong.imlib.statistics.Statistics;
import io.rong.imlib.statistics.StatisticsStore;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;

public class EventQueue {
    private final StatisticsStore statisticsStore_;

    EventQueue(StatisticsStore statisticsStore) {
        this.statisticsStore_ = statisticsStore;
    }

    int size() {
        return this.statisticsStore_.events().length;
    }

    String events() {
        List<Event> events = this.statisticsStore_.eventsList();
        JSONArray eventArray = new JSONArray();
        for (Event e : events) {
            eventArray.put((Object)e.toJSON());
        }
        String result = eventArray.toString();
        this.statisticsStore_.removeEvents(events);
        try {
            result = URLEncoder.encode(result, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    void recordEvent(String key, Map<String, String> segmentation, int count, double sum) {
        int timestamp = Statistics.currentTimestamp();
        this.statisticsStore_.addEvent(key, segmentation, timestamp, count, sum);
    }

    StatisticsStore getCountlyStore() {
        return this.statisticsStore_;
    }
}

