/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.statistics;

import android.util.Log;
import io.rong.imlib.statistics.Statistics;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class Event {
    private static final String SEGMENTATION_KEY = "segmentation";
    private static final String KEY_KEY = "key";
    private static final String COUNT_KEY = "count";
    private static final String SUM_KEY = "sum";
    private static final String TIMESTAMP_KEY = "timestamp";
    public String key;
    public Map<String, String> segmentation;
    public int count;
    public double sum;
    public int timestamp;

    Event() {
    }

    JSONObject toJSON() {
        JSONObject json;
        block3: {
            json = new JSONObject();
            try {
                json.put(KEY_KEY, (Object)this.key);
                json.put(COUNT_KEY, this.count);
                json.put(TIMESTAMP_KEY, this.timestamp);
                if (this.segmentation != null) {
                    json.put(SEGMENTATION_KEY, (Object)new JSONObject(this.segmentation));
                }
                json.put(SUM_KEY, this.sum);
            }
            catch (JSONException e) {
                if (!Statistics.sharedInstance().isLoggingEnabled()) break block3;
                Log.w((String)"Statistics", (String)"Got exception converting an Event to JSON", (Throwable)e);
            }
        }
        return json;
    }

    static Event fromJSON(JSONObject json) {
        Event event = new Event();
        try {
            if (!json.isNull(KEY_KEY)) {
                event.key = json.getString(KEY_KEY);
            }
            event.count = json.optInt(COUNT_KEY);
            event.sum = json.optDouble(SUM_KEY, 0.0);
            event.timestamp = json.optInt(TIMESTAMP_KEY);
            if (!json.isNull(SEGMENTATION_KEY)) {
                JSONObject segm = json.getJSONObject(SEGMENTATION_KEY);
                HashMap<String, String> segmentation = new HashMap<String, String>(segm.length());
                Iterator nameItr = segm.keys();
                while (nameItr.hasNext()) {
                    String key = (String)nameItr.next();
                    if (segm.isNull(key)) continue;
                    segmentation.put(key, segm.getString(key));
                }
                event.segmentation = segmentation;
            }
        }
        catch (JSONException e) {
            if (Statistics.sharedInstance().isLoggingEnabled()) {
                Log.w((String)"Statistics", (String)"Got exception converting JSON to an Event", (Throwable)e);
            }
            event = null;
        }
        return event != null && event.key != null && event.key.length() > 0 ? event : null;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Event)) {
            return false;
        }
        Event e = (Event)o;
        return (this.key == null ? e.key == null : this.key.equals(e.key)) && this.timestamp == e.timestamp && (this.segmentation == null ? e.segmentation == null : this.segmentation.equals(e.segmentation));
    }

    public int hashCode() {
        return (this.key != null ? this.key.hashCode() : 1) ^ (this.segmentation != null ? this.segmentation.hashCode() : 1) ^ (this.timestamp != 0 ? this.timestamp : 1);
    }
}

