/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.relinker.elf;

import io.rong.imlib.relinker.elf.Elf;
import io.rong.imlib.relinker.elf.Elf32Header;
import io.rong.imlib.relinker.elf.Elf64Header;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ElfParser
implements Closeable,
Elf {
    private final int MAGIC = 1179403647;
    private final FileChannel channel;

    public ElfParser(File file) throws FileNotFoundException {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException("File is null or does not exist");
        }
        FileInputStream inputStream = new FileInputStream(file);
        this.channel = inputStream.getChannel();
    }

    public Elf.Header parseHeader() throws IOException {
        boolean bigEndian;
        this.channel.position(0L);
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        if (this.readWord(buffer, 0L) != 1179403647L) {
            throw new IllegalArgumentException("Invalid ELF Magic!");
        }
        short fileClass = this.readByte(buffer, 4L);
        boolean bl = bigEndian = this.readByte(buffer, 5L) == 2;
        if (fileClass == 1) {
            return new Elf32Header(bigEndian, this);
        }
        if (fileClass == 2) {
            return new Elf64Header(bigEndian, this);
        }
        throw new IllegalStateException("Invalid class type!");
    }

    public List<String> parseNeededDependencies() throws IOException {
        Elf.DynamicStructure dynStructure;
        this.channel.position(0L);
        ArrayList<String> dependencies = new ArrayList<String>();
        Elf.Header header = this.parseHeader();
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.order(header.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        long numProgramHeaderEntries = header.phnum;
        if (numProgramHeaderEntries == 65535L) {
            Elf.SectionHeader sectionHeader = header.getSectionHeader(0);
            numProgramHeaderEntries = sectionHeader.info;
        }
        long dynamicSectionOff = 0L;
        for (long i = 0L; i < numProgramHeaderEntries; ++i) {
            Elf.ProgramHeader programHeader = header.getProgramHeader(i);
            if (programHeader.type != 2L) continue;
            dynamicSectionOff = programHeader.offset;
            break;
        }
        if (dynamicSectionOff == 0L) {
            return Collections.unmodifiableList(dependencies);
        }
        int i = 0;
        ArrayList<Long> neededOffsets = new ArrayList<Long>();
        long vStringTableOff = 0L;
        do {
            dynStructure = header.getDynamicStructure(dynamicSectionOff, i);
            if (dynStructure.tag == 1L) {
                neededOffsets.add(dynStructure.val);
            } else if (dynStructure.tag == 5L) {
                vStringTableOff = dynStructure.val;
            }
            ++i;
        } while (dynStructure.tag != 0L);
        if (vStringTableOff == 0L) {
            throw new IllegalStateException("String table offset not found!");
        }
        long stringTableOff = this.offsetFromVma(header, numProgramHeaderEntries, vStringTableOff);
        for (Long strOff : neededOffsets) {
            dependencies.add(this.readString(buffer, stringTableOff + strOff));
        }
        return dependencies;
    }

    private long offsetFromVma(Elf.Header header, long numEntries, long vma) throws IOException {
        for (long i = 0L; i < numEntries; ++i) {
            Elf.ProgramHeader programHeader = header.getProgramHeader(i);
            if (programHeader.type != 1L || programHeader.vaddr > vma || vma > programHeader.vaddr + programHeader.memsz) continue;
            return vma - programHeader.vaddr + programHeader.offset;
        }
        throw new IllegalStateException("Could not map vma to file offset!");
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    protected String readString(ByteBuffer buffer, long offset) throws IOException {
        short c;
        StringBuilder builder = new StringBuilder();
        while ((c = this.readByte(buffer, offset++)) != 0) {
            builder.append((char)c);
        }
        return builder.toString();
    }

    protected long readLong(ByteBuffer buffer, long offset) throws IOException {
        this.read(buffer, offset, 8);
        return buffer.getLong();
    }

    protected long readWord(ByteBuffer buffer, long offset) throws IOException {
        this.read(buffer, offset, 4);
        return (long)buffer.getInt() & 0xFFFFFFFFL;
    }

    protected int readHalf(ByteBuffer buffer, long offset) throws IOException {
        this.read(buffer, offset, 2);
        return buffer.getShort() & 0xFFFF;
    }

    protected short readByte(ByteBuffer buffer, long offset) throws IOException {
        this.read(buffer, offset, 1);
        return (short)(buffer.get() & 0xFF);
    }

    protected void read(ByteBuffer buffer, long offset, int length) throws IOException {
        int read;
        buffer.position(0);
        buffer.limit(length);
        for (long bytesRead = 0L; bytesRead < (long)length; bytesRead += (long)read) {
            read = this.channel.read(buffer, offset + bytesRead);
            if (read != -1) continue;
            throw new EOFException();
        }
        buffer.position(0);
    }
}

